/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.PathContainer;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final Log log = LogFactory.getLog(PathRoutePredicateFactory.class);
    private static final String MATCH_TRAILING_SLASH = "matchTrailingSlash";
    private PathPatternParser pathPatternParser = new PathPatternParser();

    public PathRoutePredicateFactory() {
        super(Config.class);
    }

    private static void traceMatch(String prefix, Object desired, Object actual, boolean match) {
        if (log.isTraceEnabled()) {
            String message = String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual);
            log.trace((Object)message);
        }
    }

    public void setPathPatternParser(PathPatternParser pathPatternParser) {
        this.pathPatternParser = pathPatternParser;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("patterns", MATCH_TRAILING_SLASH);
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST_TAIL_FLAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        final ArrayList pathPatterns = new ArrayList();
        PathPatternParser pathPatternParser = this.pathPatternParser;
        synchronized (pathPatternParser) {
            this.pathPatternParser.setMatchOptionalTrailingSeparator(config.isMatchTrailingSlash());
            config.getPatterns().forEach(pattern -> {
                PathPattern pathPattern = this.pathPatternParser.parse(pattern);
                pathPatterns.add(pathPattern);
            });
        }
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange) {
                PathContainer path = PathContainer.parsePath((String)exchange.getRequest().getURI().getRawPath());
                PathPattern match = null;
                for (int i = 0; i < pathPatterns.size(); ++i) {
                    PathPattern pathPattern = (PathPattern)pathPatterns.get(i);
                    if (!pathPattern.matches(path)) continue;
                    match = pathPattern;
                    break;
                }
                if (match != null) {
                    PathRoutePredicateFactory.traceMatch("Pattern", match.getPatternString(), path, true);
                    PathPattern.PathMatchInfo pathMatchInfo = match.matchAndExtract(path);
                    ServerWebExchangeUtils.putUriTemplateVariables(exchange, pathMatchInfo.getUriVariables());
                    exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ATTR, match.getPatternString());
                    String routeId = (String)exchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
                    if (routeId != null) {
                        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ROUTE_ID_ATTR, routeId);
                    }
                    return true;
                }
                PathRoutePredicateFactory.traceMatch("Pattern", config.getPatterns(), path, false);
                return false;
            }

            public String toString() {
                return String.format("Paths: %s, match trailing slash: %b", config.getPatterns(), config.isMatchTrailingSlash());
            }
        };
    }

    @Validated
    public static class Config {
        private List<String> patterns = new ArrayList<String>();
        private boolean matchTrailingSlash = true;

        public List<String> getPatterns() {
            return this.patterns;
        }

        public Config setPatterns(List<String> patterns) {
            this.patterns = patterns;
            return this;
        }

        @Deprecated
        public boolean isMatchOptionalTrailingSeparator() {
            return this.isMatchTrailingSlash();
        }

        @Deprecated
        public Config setMatchOptionalTrailingSeparator(boolean matchOptionalTrailingSeparator) {
            this.setMatchTrailingSlash(matchOptionalTrailingSeparator);
            return this;
        }

        public boolean isMatchTrailingSlash() {
            return this.matchTrailingSlash;
        }

        public Config setMatchTrailingSlash(boolean matchTrailingSlash) {
            this.matchTrailingSlash = matchTrailingSlash;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("patterns", this.patterns).append(PathRoutePredicateFactory.MATCH_TRAILING_SLASH, this.matchTrailingSlash).toString();
        }
    }
}

