/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.circuitbreaker;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.circuitbreaker.SleuthCircuitBreakerProperties;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceCircuitBreakerFactoryAspect;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceReactiveCircuitBreakerFactoryAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.circuitbreaker.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthCircuitBreakerProperties.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceCircuitBreakerAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.client.circuitbreaker.CircuitBreaker"})
    TraceCircuitBreakerFactoryAspect traceCircuitBreakerFactoryAspect(Tracer tracer) {
        return new TraceCircuitBreakerFactoryAspect(tracer);
    }

    @Bean
    @ConditionalOnClass(name={"reactor.core.publisher.Mono", "org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker"})
    TraceReactiveCircuitBreakerFactoryAspect traceReactiveCircuitBreakerFactoryAspect(Tracer tracer, CurrentTraceContext currentTraceContext) {
        return new TraceReactiveCircuitBreakerFactoryAspect(tracer, currentTraceContext);
    }
}

