/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.messaging;

import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.messaging.MessageHandler;

public class DirectWithAttributesChannel
extends DirectChannel {
    public static String COMPANION_ATTR = "companion";
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getBeanName() {
        return this.getComponentName();
    }

    public void destroy() {
        super.destroy();
        Object companion = this.attributes.get(COMPANION_ATTR);
        if (companion != null && companion instanceof AbstractMessageChannel) {
            AbstractMessageChannel companionChannel = (AbstractMessageChannel)companion;
            companionChannel.destroy();
        }
    }

    public boolean subscribe(MessageHandler handler) {
        return this.getDispatcher().getHandlerCount() == 1 ? false : super.subscribe(handler);
    }
}

