/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.zookeeper.discovery.DependencyPathUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.zookeeper.discovery")
public class ZookeeperDiscoveryProperties {
    public static final String PREFIX = "spring.cloud.zookeeper.discovery";
    public static final String DEFAULT_URI_SPEC = "{scheme}://{address}:{port}";
    private InetUtils.HostInfo hostInfo;
    private boolean enabled = true;
    private String root = "/services";
    private String uriSpec = "{scheme}://{address}:{port}";
    private String instanceId;
    private String instanceHost;
    private String instanceIpAddress;
    private boolean preferIpAddress = false;
    private Integer instancePort;
    private Integer instanceSslPort;
    private boolean register = true;
    private Map<String, String> metadata = new HashMap<String, String>();
    private String initialStatus = "UP";
    private int order = 0;

    protected ZookeeperDiscoveryProperties() {
    }

    public ZookeeperDiscoveryProperties(InetUtils inetUtils) {
        this.hostInfo = inetUtils.findFirstNonLoopbackHostInfo();
        this.instanceHost = this.hostInfo.getHostname();
        this.instanceIpAddress = this.hostInfo.getIpAddress();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getRoot() {
        return this.root;
    }

    public String getUriSpec() {
        return this.uriSpec;
    }

    public String getInstanceHost() {
        if (this.preferIpAddress && StringUtils.hasText((String)this.instanceIpAddress)) {
            return this.instanceIpAddress;
        }
        return this.instanceHost;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRoot(String root) {
        this.root = DependencyPathUtils.sanitize(root);
    }

    public void setUriSpec(String uriSpec) {
        this.uriSpec = uriSpec;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInstanceHost(String instanceHost) {
        this.instanceHost = instanceHost;
        this.hostInfo.override = true;
    }

    public void setInstanceIpAddress(String instanceIpAddress) {
        this.instanceIpAddress = instanceIpAddress;
        this.hostInfo.override = true;
    }

    public void setPreferIpAddress(boolean preferIpAddress) {
        this.preferIpAddress = preferIpAddress;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean isRegister() {
        return this.register;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public Integer getInstancePort() {
        return this.instancePort;
    }

    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    public Integer getInstanceSslPort() {
        return this.instanceSslPort;
    }

    public void setInstanceSslPort(Integer instanceSslPort) {
        this.instanceSslPort = instanceSslPort;
    }

    public String getInitialStatus() {
        return this.initialStatus;
    }

    public void setInitialStatus(String initialStatus) {
        this.initialStatus = initialStatus;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String toString() {
        return "ZookeeperDiscoveryProperties{enabled=" + this.enabled + ", root='" + this.root + "', uriSpec='" + this.uriSpec + "', instanceId='" + this.instanceId + "', instanceHost='" + this.instanceHost + "', instancePort='" + this.instancePort + "', instanceSslPort='" + this.instanceSslPort + "', metadata=" + this.metadata + ", register=" + this.register + ", initialStatus=" + this.initialStatus + ", order=" + this.order + "}";
    }
}

