/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import com.mongodb.DBRef;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.CodeWScope;
import org.bson.types.CodeWithScope;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public abstract class MongoSimpleTypes {
    public static final Set<Class<?>> AUTOGENERATED_ID_TYPES;
    private static final Set<Class<?>> MONGO_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    private MongoSimpleTypes() {
    }

    static {
        HashSet<Class<BigInteger>> classes = new HashSet<Class<BigInteger>>();
        classes.add(ObjectId.class);
        classes.add(String.class);
        classes.add(BigInteger.class);
        AUTOGENERATED_ID_TYPES = Collections.unmodifiableSet(classes);
        HashSet<Class> simpleTypes = new HashSet<Class>();
        simpleTypes.add(DBRef.class);
        simpleTypes.add(ObjectId.class);
        simpleTypes.add(BsonObjectId.class);
        simpleTypes.add(CodeWScope.class);
        simpleTypes.add(CodeWithScope.class);
        simpleTypes.add(Document.class);
        simpleTypes.add(Pattern.class);
        simpleTypes.add(Binary.class);
        simpleTypes.add(UUID.class);
        simpleTypes.add(Decimal128.class);
        simpleTypes.add(BsonBinary.class);
        simpleTypes.add(BsonBoolean.class);
        simpleTypes.add(BsonDateTime.class);
        simpleTypes.add(BsonDbPointer.class);
        simpleTypes.add(BsonDecimal128.class);
        simpleTypes.add(BsonDocument.class);
        simpleTypes.add(BsonDocument.class);
        simpleTypes.add(BsonDouble.class);
        simpleTypes.add(BsonInt32.class);
        simpleTypes.add(BsonInt64.class);
        simpleTypes.add(BsonJavaScript.class);
        simpleTypes.add(BsonJavaScriptWithScope.class);
        simpleTypes.add(BsonObjectId.class);
        simpleTypes.add(BsonRegularExpression.class);
        simpleTypes.add(BsonString.class);
        simpleTypes.add(BsonTimestamp.class);
        MONGO_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(MONGO_SIMPLE_TYPES, true);
    }
}

