/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.util.Assert;

public class AnnotationMappingDiscoverer
implements MappingDiscoverer {
    private static final Pattern MULTIPLE_SLASHES = Pattern.compile("\\/{2,}");
    private final Class<? extends Annotation> annotationType;
    private final String mappingAttributeName;

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation) {
        this(annotation, null);
    }

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation, String mappingAttributeName) {
        Assert.notNull(annotation);
        this.annotationType = annotation;
        this.mappingAttributeName = mappingAttributeName;
    }

    @Override
    public String getMapping(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        String[] mapping = this.getMappingFrom(AnnotationUtils.findAnnotation(type, this.annotationType));
        return mapping.length == 0 ? null : mapping[0];
    }

    @Override
    public String getMapping(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return this.getMapping(method.getDeclaringClass(), method);
    }

    @Override
    public String getMapping(Class<?> type, Method method) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        String[] mapping = this.getMappingFrom(AnnotationUtils.findAnnotation((Method)method, this.annotationType));
        String typeMapping = this.getMapping(type);
        if (mapping == null || mapping.length == 0) {
            return typeMapping;
        }
        return typeMapping == null || "/".equals(typeMapping) ? mapping[0] : AnnotationMappingDiscoverer.join(typeMapping, mapping[0]);
    }

    private String[] getMappingFrom(Annotation annotation) {
        Object value;
        Object object = value = this.mappingAttributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)this.mappingAttributeName);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value == null) {
            return new String[0];
        }
        throw new IllegalStateException(String.format("Unsupported type for the mapping attribute! Support String and String[] but got %s!", value.getClass()));
    }

    private static String join(String typeMapping, String mapping) {
        return MULTIPLE_SLASHES.matcher(typeMapping.concat("/").concat(mapping)).replaceAll("/");
    }
}

