/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.conditionalcomments.dialect.processor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.extras.conditionalcomments.dialect.processor.ConditionalCommentNodeProcessorMatcher;
import org.thymeleaf.extras.conditionalcomments.parser.ConditionalCommentAttoTemplateParser;
import org.thymeleaf.extras.conditionalcomments.util.ConditionalCommentParsingResult;
import org.thymeleaf.extras.conditionalcomments.util.ConditionalCommentUtils;
import org.thymeleaf.processor.ICommentNodeProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.comment.AbstractCommentNodeProcessor;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templatewriter.ITemplateWriter;

public class ConditionalCommentProcessor
extends AbstractCommentNodeProcessor {
    public static final int PRECEDENCE = 1000;

    public ConditionalCommentProcessor() {
        super((ICommentNodeProcessorMatcher)ConditionalCommentNodeProcessorMatcher.INSTANCE);
    }

    public int getPrecedence() {
        return 1000;
    }

    protected ProcessorResult processCommentNode(Arguments arguments, Comment commentNode) {
        ConditionalCommentParsingResult parsingResult = ConditionalCommentUtils.parseConditionalComment(commentNode.getContent());
        StringWriter writer = new StringWriter();
        writer.write("[");
        writer.write(parsingResult.getText(), parsingResult.getStartExpressionOffset(), parsingResult.getStartExpressionLen());
        writer.write("]>");
        ConditionalCommentAttoTemplateParser parser = new ConditionalCommentAttoTemplateParser();
        List<Node> nodes = parser.parseFragment(arguments.getConfiguration(), parsingResult.getText(), parsingResult.getContentOffset(), parsingResult.getContentLen());
        String templateMode = arguments.getTemplateResolution().getTemplateMode();
        ITemplateModeHandler templateModeHandler = arguments.getConfiguration().getTemplateModeHandler(templateMode);
        ITemplateWriter templateWriter = templateModeHandler.getTemplateWriter();
        Document document = new Document("[Conditional Comment at line: " + commentNode.getLineNumber() + "]");
        document.setChildren(nodes);
        document.process(arguments);
        try {
            templateWriter.write(arguments, (Writer)writer, document);
        }
        catch (IOException e) {
            throw new TemplateProcessingException("Error writing result of processing conditional comment at line " + commentNode.getLineNumber(), (Throwable)e);
        }
        writer.write("<![");
        writer.write(parsingResult.getText(), parsingResult.getEndExpressionOffset(), parsingResult.getEndExpressionLen());
        writer.write("]");
        commentNode.setContent(writer.toString());
        return ProcessorResult.OK;
    }
}

