/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.spring4.web.factory;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.CachingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.preparer.PreparerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.view.tiles2.TilesConfigurer;
import org.thymeleaf.extras.tiles2.spring4.web.configurer.ThymeleafTilesConfigurer;
import org.thymeleaf.extras.tiles2.spring4.web.factory.TilesConfigurerSuperClassIntegration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThymeleafTilesContainerFactory
extends org.thymeleaf.extras.tiles2.factory.ThymeleafTilesContainerFactory {
    private final ThymeleafTilesConfigurer configurer;

    public ThymeleafTilesContainerFactory(ThymeleafTilesConfigurer configurer) {
        this.configurer = configurer;
    }

    protected BasicTilesContainer instantiateContainer(TilesApplicationContext context) {
        boolean useMutableTilesContainer = TilesConfigurerSuperClassIntegration.getUseMutableTilesContainer(this.configurer);
        return useMutableTilesContainer ? new CachingTilesContainer() : new BasicTilesContainer();
    }

    protected void registerRequestContextFactory(String className, List<TilesRequestContextFactory> factories, TilesRequestContextFactory parent) {
        if (ClassUtils.isPresent((String)className, (ClassLoader)TilesConfigurer.class.getClassLoader())) {
            super.registerRequestContextFactory(className, factories, parent);
        }
    }

    protected List<URL> getSourceURLs(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        String[] definitions = TilesConfigurerSuperClassIntegration.getDefinitions(this.configurer);
        if (definitions != null) {
            try {
                LinkedList<URL> result = new LinkedList<URL>();
                for (String definition : definitions) {
                    result.addAll(applicationContext.getResources(definition));
                }
                return result;
            }
            catch (IOException ex) {
                throw new DefinitionsFactoryException("Cannot load definition URLs", (Exception)ex);
            }
        }
        return super.getSourceURLs(applicationContext, contextFactory);
    }

    protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        BaseLocaleUrlDefinitionDAO dao = super.instantiateLocaleDefinitionDao(applicationContext, contextFactory, resolver);
        boolean checkRefresh = TilesConfigurerSuperClassIntegration.getCheckRefresh(this.configurer);
        if (checkRefresh && dao instanceof CachingLocaleUrlDefinitionDAO) {
            ((CachingLocaleUrlDefinitionDAO)dao).setCheckRefresh(checkRefresh);
        }
        return dao;
    }

    protected DefinitionsReader createDefinitionsReader(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        DigesterDefinitionsReader reader = new DigesterDefinitionsReader();
        boolean validateDefinitions = TilesConfigurerSuperClassIntegration.getValidateDefinitions(this.configurer);
        if (!validateDefinitions) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.FALSE.toString());
            reader.init(map);
        }
        return reader;
    }

    protected DefinitionsFactory createDefinitionsFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        Class<? extends DefinitionsFactory> definitionsFactoryClass = TilesConfigurerSuperClassIntegration.getDefinitionsFactoryClass(this.configurer);
        if (definitionsFactoryClass != null) {
            BeanWrapper bw;
            DefinitionsFactory factory = (DefinitionsFactory)BeanUtils.instantiate(definitionsFactoryClass);
            if (factory instanceof TilesApplicationContextAware) {
                ((TilesApplicationContextAware)factory).setApplicationContext(applicationContext);
            }
            if ((bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)factory)).isWritableProperty("localeResolver")) {
                bw.setPropertyValue("localeResolver", (Object)resolver);
            }
            if (bw.isWritableProperty("definitionDAO")) {
                bw.setPropertyValue("definitionDAO", (Object)this.createLocaleDefinitionDao(applicationContext, contextFactory, resolver));
            }
            if (factory instanceof Refreshable) {
                ((Refreshable)factory).refresh();
            }
            return factory;
        }
        return super.createDefinitionsFactory(applicationContext, contextFactory, resolver);
    }

    protected PreparerFactory createPreparerFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        Class<? extends PreparerFactory> preparerFactoryClass = TilesConfigurerSuperClassIntegration.getPreparerFactoryClass(this.configurer);
        if (preparerFactoryClass != null) {
            return (PreparerFactory)BeanUtils.instantiate(preparerFactoryClass);
        }
        return super.createPreparerFactory(applicationContext, contextFactory);
    }
}

