/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.dialect.processor;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.template.AttributeResolver;
import org.apache.tiles.template.DefaultAttributeResolver;
import org.apache.tiles.template.InsertAttributeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.AbstractDialectAwareProcessingContext;
import org.thymeleaf.context.DialectAwareProcessingContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Macro;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.extras.tiles2.renderer.FragmentMetadata;
import org.thymeleaf.extras.tiles2.request.LocalVariablesHttpServletRequest;
import org.thymeleaf.processor.attr.AbstractChildrenModifierAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTilesFragmentHandlingAttrProcessor
extends AbstractChildrenModifierAttrProcessor {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final InsertAttributeModel model = new InsertAttributeModel((AttributeResolver)new DefaultAttributeResolver());

    public AbstractTilesFragmentHandlingAttrProcessor(String attributeName) {
        super(attributeName);
    }

    protected final List<Node> getModifiedChildren(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        boolean replaceHostElement = this.getReplaceHostElement(arguments, element, attributeName);
        IContext context = arguments.getContext();
        if (!(context instanceof IWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a web context (implementation of " + IWebContext.class.getName() + ". Tiles integration can only be used in " + "web environements.");
        }
        IWebContext webContext = (IWebContext)context;
        DialectAwareProcessingContext processingContext = new DialectAwareProcessingContext((AbstractDialectAwareProcessingContext)arguments);
        HttpServletRequest request = webContext.getHttpServletRequest();
        HttpServletResponse response = webContext.getHttpServletResponse();
        ServletContext servletContext = webContext.getServletContext();
        LocalVariablesHttpServletRequest localVariablesHttpServletRequest = new LocalVariablesHttpServletRequest(request, processingContext.getLocalVariables());
        TilesContainer tilesContainer = ServletUtil.getContainer((ServletContext)servletContext);
        boolean ignore = false;
        String preparer = null;
        String role = null;
        Object defaultValue = null;
        String defaultValueRole = null;
        String defaultValueType = null;
        String name = attributeValue;
        Attribute value = null;
        TemplateEngine templateEngine = arguments.getTemplateEngine();
        StringWriter writer = new StringWriter();
        FragmentMetadata fragmentMetadata = new FragmentMetadata(name);
        fragmentMetadata.setDisplayOnlyChildren(!replaceHostElement);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[THYMELEAF][{}][{}] Executing Tiles Model of class {}for attribute \"{}\" with value \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), this.model.getClass().getName(), attributeName, attributeValue});
        }
        try {
            this.model.execute(tilesContainer, false, preparer, role, defaultValue, defaultValueRole, defaultValueType, name, value, new Object[]{templateEngine, processingContext, localVariablesHttpServletRequest, response, writer, fragmentMetadata});
        }
        catch (IOException e) {
            throw new TemplateProcessingException("Error while processing Tiles attribute \"" + name + "\"", (Throwable)e);
        }
        String templateResult = writer.toString();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[THYMELEAF][{}][{}] Correctly executed Tiles Model of class {}for attribute \"{}\" with value \"{}\", result is:\n{}", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), this.model.getClass().getName(), attributeName, attributeValue, templateResult});
        }
        Macro macroNode = new Macro(templateResult);
        return Collections.singletonList(macroNode);
    }
}

