/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.digitalforge.log4jdbc.JdbcSpy;
import org.digitalforge.log4jdbc.LoggingConnection;
import org.digitalforge.log4jdbc.LoggingDriver;
import org.digitalforge.log4jdbc.LoggingResultSet;
import org.digitalforge.log4jdbc.LoggingStatement;
import org.digitalforge.log4jdbc.SpyLogDelegator;
import org.digitalforge.log4jdbc.SpyLogFactory;
import org.digitalforge.log4jdbc.util.Utilities;

public class LoggingPreparedStatement<S extends PreparedStatement>
extends LoggingStatement<S>
implements PreparedStatement {
    private static final SpyLogDelegator log = SpyLogFactory.getSpyLogDelegator();
    protected final List<String> argTrace = new ArrayList<String>();
    private static final boolean showTypeHelp = false;
    private String sql;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void argTraceSet(int i, String typeHelper, Object arg) {
        String tracedArg;
        try {
            tracedArg = this.parameterFormatter.formatParameterObject(arg);
        }
        catch (Throwable t) {
            log.debug("rdbmsSpecifics threw an exception while trying to format a parameter object [" + arg + "] this is very bad!!! (" + t.getMessage() + ")");
            tracedArg = arg == null ? "null" : arg.toString();
        }
        --i;
        List<String> list = this.argTrace;
        synchronized (list) {
            while (i >= this.argTrace.size()) {
                this.argTrace.add(this.argTrace.size(), null);
            }
            this.argTrace.set(i, tracedArg);
        }
    }

    @Override
    public String getCurrentSql() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String dumpedSql() {
        if (LoggingDriver.config.isReportOriginalSql()) {
            return this.sql;
        }
        StringBuffer dumpSql = new StringBuffer();
        int lastPos = 0;
        int qPos = this.sql.indexOf(63, lastPos);
        int argIdx = 0;
        while (qPos != -1) {
            String arg;
            List<String> list = this.argTrace;
            synchronized (list) {
                try {
                    arg = this.argTrace.get(argIdx);
                }
                catch (IndexOutOfBoundsException e) {
                    arg = "?";
                }
            }
            if (arg == null) {
                arg = "?";
            }
            ++argIdx;
            dumpSql.append(this.sql.substring(lastPos, qPos));
            lastPos = qPos + 1;
            qPos = this.sql.indexOf(63, lastPos);
            dumpSql.append(arg);
        }
        if (lastPos < this.sql.length()) {
            dumpSql.append(this.sql.substring(lastPos, this.sql.length()));
        }
        return dumpSql.toString();
    }

    @Override
    protected void reportAllReturns(String methodCall, String msg) {
        log.methodReturned(this, methodCall, msg);
    }

    public LoggingPreparedStatement(String sql, LoggingConnection connection, S delegate) {
        super(connection, delegate);
        this.sql = sql;
        this.parameterFormatter = connection.getParameterFormatter();
    }

    @Override
    public String getClassType() {
        return "PreparedStatement";
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        String methodCall = "setTime(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<Time>*/", x);
        try {
            ((PreparedStatement)this.delegate).setTime(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String methodCall = "setTime(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "/*<Time>*/", x);
        try {
            ((PreparedStatement)this.delegate).setTime(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String methodCall = "setNull(" + parameterIndex + ", " + sqlType + ")";
        this.argTraceSet(parameterIndex, null, null);
        try {
            ((PreparedStatement)this.delegate).setNull(parameterIndex, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        String methodCall = "setNull(" + paramIndex + ", " + sqlType + ", " + typeName + ")";
        this.argTraceSet(paramIndex, null, null);
        try {
            ((PreparedStatement)this.delegate).setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        String methodCall = "setRef(" + i + ", " + x + ")";
        this.argTraceSet(i, "/*<Ref>*/", x);
        try {
            ((PreparedStatement)this.delegate).setRef(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        String methodCall = "setBoolean(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<boolean>*/", x);
        try {
            ((PreparedStatement)this.delegate).setBoolean(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        String methodCall = "setBlob(" + i + ", " + x + ")";
        this.argTraceSet(i, "/*<Blob>*/", x == null ? null : "<Blob of size " + x.length() + ">");
        try {
            ((PreparedStatement)this.delegate).setBlob(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        String methodCall = "setClob(" + i + ", " + x + ")";
        this.argTraceSet(i, "/*<Clob>*/", x == null ? null : "<Clob of size " + x.length() + ">");
        try {
            ((PreparedStatement)this.delegate).setClob(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        String methodCall = "setArray(" + i + ", " + x + ")";
        this.argTraceSet(i, "/*<Array>*/", "<Array>");
        try {
            ((PreparedStatement)this.delegate).setArray(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        String methodCall = "setByte(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<byte>*/", x);
        try {
            ((PreparedStatement)this.delegate).setByte(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setUnicodeStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Unicode InputStream>*/", "<Unicode InputStream of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        String methodCall = "setShort(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<short>*/", x);
        try {
            ((PreparedStatement)this.delegate).setShort(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean execute() throws SQLException {
        String methodCall = "execute()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            boolean result = ((PreparedStatement)this.delegate).execute();
            this.reportSqlTiming(System.nanoTime() - tstartNano, dumpedSql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        String methodCall = "setInt(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<int>*/", x);
        try {
            ((PreparedStatement)this.delegate).setInt(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        String methodCall = "setLong(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<long>*/", x);
        try {
            ((PreparedStatement)this.delegate).setLong(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        String methodCall = "setFloat(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<float>*/", Float.valueOf(x));
        try {
            ((PreparedStatement)this.delegate).setFloat(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        String methodCall = "setDouble(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<double>*/", new Double(x));
        try {
            ((PreparedStatement)this.delegate).setDouble(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        String methodCall = "setBigDecimal(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<BigDecimal>*/", x);
        try {
            ((PreparedStatement)this.delegate).setBigDecimal(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        String methodCall = "setURL(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<URL>*/", x);
        try {
            ((PreparedStatement)this.delegate).setURL(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        String methodCall = "setString(" + parameterIndex + ", \"" + x + "\")";
        this.argTraceSet(parameterIndex, "/*<String>*/", x);
        try {
            ((PreparedStatement)this.delegate).setString(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        String methodCall = "setBytes(" + parameterIndex + ", " + x + ")";
        String argVal = x.length <= 32 ? "0x" + Utilities.hex(x) : "<byte[" + x.length + "]>";
        this.argTraceSet(parameterIndex, "/*<byte[]>*/", argVal);
        try {
            ((PreparedStatement)this.delegate).setBytes(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        String methodCall = "setDate(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<Date>*/", x);
        try {
            ((PreparedStatement)this.delegate).setDate(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        String methodCall = "getParameterMetaData()";
        try {
            return this.reportReturn(methodCall, ((PreparedStatement)this.delegate).getParameterMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        String methodCall = "setRowId(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<RowId>*/", x);
        try {
            ((PreparedStatement)this.delegate).setRowId(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        String methodCall = "setNString(" + parameterIndex + ", " + value + ")";
        this.argTraceSet(parameterIndex, "/*<String>*/", value);
        try {
            ((PreparedStatement)this.delegate).setNString(parameterIndex, value);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        String methodCall = "setNCharacterStream(" + parameterIndex + ", " + value + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        String methodCall = "setNClob(" + parameterIndex + ", " + value + ")";
        this.argTraceSet(parameterIndex, "/*<NClob>*/", "<NClob>");
        try {
            ((PreparedStatement)this.delegate).setNClob(parameterIndex, value);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String methodCall = "setClob(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setClob(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        String methodCall = "setBlob(" + parameterIndex + ", " + inputStream + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<InputStream>*/", "<InputStream of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String methodCall = "setNClob(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setNClob(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String methodCall = "setSQLXML(" + parameterIndex + ", " + xmlObject + ")";
        this.argTraceSet(parameterIndex, "/*<SQLXML>*/", xmlObject);
        try {
            ((PreparedStatement)this.delegate).setSQLXML(parameterIndex, xmlObject);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String methodCall = "setDate(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "/*<Date>*/", x);
        try {
            ((PreparedStatement)this.delegate).setDate(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        String methodCall = "executeQuery()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            ResultSet r = ((PreparedStatement)this.delegate).executeQuery();
            this.reportSqlTiming(System.nanoTime() - tstartNano, dumpedSql, methodCall);
            LoggingResultSet rsp = new LoggingResultSet(this, r);
            return this.reportReturn(methodCall, rsp);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    private String getTypeHelp(Object x) {
        if (x == null) {
            return "/*<null>*/";
        }
        return "(" + x.getClass().getName() + ")";
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ", " + scale + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), x);
        try {
            ((PreparedStatement)this.delegate).setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Ascii InputStream>*/", "<Ascii InputStream of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Binary InputStream>*/", "<Binary InputStream of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<Ascii InputStream>*/", "<Ascii InputStream>");
        try {
            ((PreparedStatement)this.delegate).setAsciiStream(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<Binary InputStream>*/", "<Binary InputStream>");
        try {
            ((PreparedStatement)this.delegate).setBinaryStream(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader>");
        try {
            ((PreparedStatement)this.delegate).setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setNCharacterStream(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader>");
        try {
            ((PreparedStatement)this.delegate).setNCharacterStream(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setClob(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader>");
        try {
            ((PreparedStatement)this.delegate).setClob(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        String methodCall = "setBlob(" + parameterIndex + ", " + inputStream + ")";
        this.argTraceSet(parameterIndex, "/*<InputStream>*/", "<InputStream>");
        try {
            ((PreparedStatement)this.delegate).setBlob(parameterIndex, inputStream);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setNClob(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "/*<Reader>*/", "<Reader>");
        try {
            ((PreparedStatement)this.delegate).setNClob(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), x);
        try {
            ((PreparedStatement)this.delegate).setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), x);
        try {
            ((PreparedStatement)this.delegate).setObject(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String methodCall = "setTimestamp(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "/*<Date>*/", x);
        try {
            ((PreparedStatement)this.delegate).setTimestamp(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        String methodCall = "setTimestamp(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "/*<Timestamp>*/", x);
        try {
            ((PreparedStatement)this.delegate).setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int executeUpdate() throws SQLException {
        String methodCall = "executeUpdate()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            int result = ((PreparedStatement)this.delegate).executeUpdate();
            this.reportSqlTiming(System.nanoTime() - tstartNano, dumpedSql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Ascii InputStream>*/", "<Ascii InputStream of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "/*<Binary InputStream>*/", "<Binary InputStream of length " + length + ">");
        try {
            ((PreparedStatement)this.delegate).setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        String methodCall = "clearParameters()";
        List<String> list = this.argTrace;
        synchronized (list) {
            this.argTrace.clear();
        }
        try {
            ((PreparedStatement)this.delegate).clearParameters();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return this.reportReturn(methodCall, ((PreparedStatement)this.delegate).getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        String methodCall = "addBatch()";
        this.currentBatch.add(this.dumpedSql());
        try {
            ((PreparedStatement)this.delegate).addBatch();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == PreparedStatement.class || iface == Statement.class || iface == JdbcSpy.class) ? this : ((PreparedStatement)this.delegate).unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == PreparedStatement.class || iface == Statement.class || iface == JdbcSpy.class) || ((PreparedStatement)this.delegate).isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ", " + scaleOrLength + ")";
        this.argTraceSet(parameterIndex, targetSqlType.getName(), x);
        try {
            ((PreparedStatement)this.delegate).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ")";
        this.argTraceSet(parameterIndex, targetSqlType.getName(), x);
        try {
            ((PreparedStatement)this.delegate).setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        String methodCall = "executeLargeUpdate()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            long result = ((PreparedStatement)this.delegate).executeLargeUpdate();
            this.reportSqlTiming(System.nanoTime() - tstartNano, dumpedSql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.nanoTime() - tstartNano);
            throw s;
        }
    }
}

