/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.digitalforge.log4jdbc.JdbcSpy;
import org.digitalforge.log4jdbc.LoggingConnection;
import org.digitalforge.log4jdbc.LoggingResultSet;
import org.digitalforge.log4jdbc.SpyLogDelegator;
import org.digitalforge.log4jdbc.SpyLogFactory;
import org.digitalforge.log4jdbc.formatter.ParameterFormatter;
import org.digitalforge.log4jdbc.util.Utilities;

public class LoggingStatement<S extends Statement>
implements Statement,
JdbcSpy {
    private static final SpyLogDelegator log = SpyLogFactory.getSpyLogDelegator();
    protected LoggingConnection connection;
    protected ParameterFormatter parameterFormatter;
    protected S delegate;
    private String currentSql;
    private static final String StatementSqlWarning = "{WARNING: Statement used to run SQL} ";
    protected List<String> currentBatch = new ArrayList<String>();

    public S getDelegate() {
        return this.delegate;
    }

    public String getCurrentSql() {
        return this.currentSql;
    }

    public LoggingStatement(LoggingConnection connection, S delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Must pass in a non null real Statement");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Must pass in a non null ConnectionSpy");
        }
        this.delegate = delegate;
        this.connection = connection;
        this.parameterFormatter = connection.getParameterFormatter();
        if (delegate instanceof CallableStatement) {
            this.reportReturn("new CallableStatement");
        } else if (delegate instanceof PreparedStatement) {
            this.reportReturn("new PreparedStatement");
        } else {
            this.reportReturn("new Statement");
        }
    }

    @Override
    public String getClassType() {
        return "Statement";
    }

    @Override
    public Integer getConnectionNumber() {
        return this.connection.getConnectionNumber();
    }

    protected void reportException(String methodCall, SQLException exception, String sql, long execTimeNanoSec) {
        log.exceptionOccured(this, methodCall, exception, sql, execTimeNanoSec);
    }

    protected void reportException(String methodCall, SQLException exception, String sql) {
        log.exceptionOccured(this, methodCall, exception, sql, -1L);
    }

    protected void reportException(String methodCall, SQLException exception) {
        log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    protected void reportAllReturns(String methodCall, String msg) {
        log.methodReturned(this, methodCall, msg);
    }

    protected boolean reportReturn(String methodCall, boolean value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected byte reportReturn(String methodCall, byte value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected int reportReturn(String methodCall, int value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected double reportReturn(String methodCall, double value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected short reportReturn(String methodCall, short value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected long reportReturn(String methodCall, long value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected float reportReturn(String methodCall, float value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected <T> T reportReturn(String methodCall, T value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected void reportReturn(String methodCall) {
        this.reportAllReturns(methodCall, "");
    }

    protected void reportStatementSql(String sql, String methodCall) {
        this.reportSql2(sql, methodCall);
    }

    protected void reportStatementSqlTiming(long execTimeNanoSec, String sql, String methodCall) {
        this.reportSqlTiming2(execTimeNanoSec, sql, methodCall);
    }

    protected void reportSqlTiming(long execTimeNanoSec, String sql, String methodCall) {
        this.reportSqlTiming2(execTimeNanoSec, sql, methodCall);
    }

    protected void reportSql(String sql, String methodCall) {
        this.reportSql2(sql, methodCall);
    }

    private void reportSql2(String sql, String methodCall) {
        this.currentSql = sql;
        log.sqlOccured(this, methodCall, sql);
    }

    private void reportSqlTiming2(long execTimeNanoSec, String sql, String methodCall) {
        log.sqlTimingOccured(this, execTimeNanoSec, methodCall, sql);
        this.currentSql = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return this.reportReturn(methodCall, this.delegate.getWarnings());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ", " + columnNames + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            int result = this.delegate.executeUpdate(sql, columnNames);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String methodCall = "execute(" + sql + ", " + columnNames + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            boolean result = this.delegate.execute(sql, columnNames);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        String methodCall = "setMaxRows(" + max + ")";
        try {
            this.delegate.setMaxRows(max);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        String methodCall = "getMoreResults()";
        try {
            return this.reportReturn(methodCall, this.delegate.getMoreResults());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.delegate.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String methodCall = "addBatch(" + sql + ")";
        this.currentBatch.add(StatementSqlWarning + sql);
        try {
            this.delegate.addBatch(sql);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getResultSetType() throws SQLException {
        String methodCall = "getResultSetType()";
        try {
            return this.reportReturn(methodCall, this.delegate.getResultSetType());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        String methodCall = "clearBatch()";
        try {
            this.delegate.clearBatch();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.currentBatch.clear();
        this.reportReturn(methodCall);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        String methodCall = "setFetchDirection(" + direction + ")";
        try {
            this.delegate.setFetchDirection(direction);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] updateResults;
        String sql;
        String methodCall = "executeBatch()";
        int j = this.currentBatch.size();
        if (j > 1) {
            StringBuffer batchReport = new StringBuffer("batching " + j + " statements:");
            int fieldSize = ("" + j).length();
            int i = 0;
            while (i < j) {
                sql = this.currentBatch.get(i);
                batchReport.append("\n");
                batchReport.append(Utilities.rightJustify(fieldSize, "" + ++i));
                batchReport.append(":  ");
                batchReport.append(sql);
            }
            sql = batchReport.toString();
        } else {
            sql = this.currentBatch.get(0);
        }
        this.reportSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            updateResults = this.delegate.executeBatch();
            this.reportSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
        this.currentBatch.clear();
        return this.reportReturn(methodCall, updateResults);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        String methodCall = "setFetchSize(" + rows + ")";
        try {
            this.delegate.setFetchSize(rows);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        String methodCall = "getQueryTimeout()";
        try {
            return this.reportReturn(methodCall, this.delegate.getQueryTimeout());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        String methodCall = "getConnection()";
        return this.reportReturn(methodCall, this.connection);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String methodCall = "getGeneratedKeys()";
        try {
            ResultSet r = this.delegate.getGeneratedKeys();
            if (r == null) {
                return this.reportReturn(methodCall, r);
            }
            return this.reportReturn(methodCall, new LoggingResultSet(this, r));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        String methodCall = "setEscapeProcessing(" + enable + ")";
        try {
            this.delegate.setEscapeProcessing(enable);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        String methodCall = "getFetchDirection()";
        try {
            return this.reportReturn(methodCall, this.delegate.getFetchDirection());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        String methodCall = "setQueryTimeout(" + seconds + ")";
        try {
            this.delegate.setQueryTimeout(seconds);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        String methodCall = "getMoreResults(" + current + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getMoreResults(current));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String methodCall = "executeQuery(" + sql + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            ResultSet result = this.delegate.executeQuery(sql);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            LoggingResultSet r = new LoggingResultSet(this, result);
            return this.reportReturn(methodCall, r);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        String methodCall = "getMaxFieldSize()";
        try {
            return this.reportReturn(methodCall, this.delegate.getMaxFieldSize());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            int result = this.delegate.executeUpdate(sql);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public void cancel() throws SQLException {
        String methodCall = "cancel()";
        try {
            this.delegate.cancel();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        String methodCall = "setCursorName(" + name + ")";
        try {
            this.delegate.setCursorName(name);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getFetchSize() throws SQLException {
        String methodCall = "getFetchSize()";
        try {
            return this.reportReturn(methodCall, this.delegate.getFetchSize());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        String methodCall = "getResultSetConcurrency()";
        try {
            return this.reportReturn(methodCall, this.delegate.getResultSetConcurrency());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        String methodCall = "getResultSetHoldability()";
        try {
            return this.reportReturn(methodCall, this.delegate.getResultSetHoldability());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodCall = "isClosed()";
        try {
            return this.reportReturn(methodCall, this.delegate.isClosed());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        String methodCall = "setPoolable(" + poolable + ")";
        try {
            this.delegate.setPoolable(poolable);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        String methodCall = "isPoolable()";
        try {
            return this.reportReturn(methodCall, this.delegate.isPoolable());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        String methodCall = "closeOnCompletion()";
        try {
            this.delegate.closeOnCompletion();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        String methodCall = "isCloseOnCompletion()";
        try {
            return this.reportReturn(methodCall, this.delegate.isCloseOnCompletion());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        String methodCall = "getLargeUpdateCount()";
        try {
            return this.reportReturn(methodCall, this.delegate.getLargeUpdateCount());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        String methodCall = "setLargeMaxRows(" + max + ")";
        try {
            this.delegate.setLargeMaxRows(max);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        String methodCall = "getLargeMaxRows()";
        try {
            return this.reportReturn(methodCall, this.delegate.getLargeMaxRows());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        long[] updateResults;
        String sql;
        String methodCall = "executeLargeBatch()";
        int j = this.currentBatch.size();
        StringBuffer batchReport = new StringBuffer("batching " + j + " statements:");
        int fieldSize = ("" + j).length();
        int i = 0;
        while (i < j) {
            sql = this.currentBatch.get(i);
            batchReport.append("\n");
            batchReport.append(Utilities.rightJustify(fieldSize, "" + ++i));
            batchReport.append(":  ");
            batchReport.append(sql);
        }
        sql = batchReport.toString();
        this.reportSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            updateResults = this.delegate.executeLargeBatch();
            this.reportSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
        this.currentBatch.clear();
        return this.reportReturn(methodCall, updateResults);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        String methodCall = "executeLargeUpdate(" + sql + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            long result = this.delegate.executeLargeUpdate(sql);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "executeLargeUpdate(" + sql + ", " + autoGeneratedKeys + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            long result = this.delegate.executeLargeUpdate(sql, autoGeneratedKeys);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "executeLargeUpdate(" + sql + ", " + columnIndexes + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            long result = this.delegate.executeLargeUpdate(sql, columnIndexes);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        String methodCall = "executeLargeUpdate(" + sql + ", " + columnNames + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            long result = this.delegate.executeLargeUpdate(sql, columnNames);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        String methodCall = "setMaxFieldSize(" + max + ")";
        try {
            this.delegate.setMaxFieldSize(max);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String methodCall = "execute(" + sql + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            boolean result = this.delegate.execute(sql);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ", " + autoGeneratedKeys + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            int result = this.delegate.executeUpdate(sql, autoGeneratedKeys);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "execute(" + sql + ", " + autoGeneratedKeys + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            boolean result = this.delegate.execute(sql, autoGeneratedKeys);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ", " + columnIndexes + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            int result = this.delegate.executeUpdate(sql, columnIndexes);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "execute(" + sql + ", " + columnIndexes + ")";
        this.reportStatementSql(sql, methodCall);
        long tstartNano = System.nanoTime();
        try {
            boolean result = this.delegate.execute(sql, columnIndexes);
            this.reportStatementSqlTiming(System.nanoTime() - tstartNano, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.nanoTime() - tstartNano);
            throw s;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        String methodCall = "getResultSet()";
        try {
            ResultSet r = this.delegate.getResultSet();
            if (r == null) {
                return this.reportReturn(methodCall, r);
            }
            return this.reportReturn(methodCall, new LoggingResultSet(this, r));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        String methodCall = "getMaxRows()";
        try {
            return this.reportReturn(methodCall, this.delegate.getMaxRows());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void close() throws SQLException {
        String methodCall = "close()";
        try {
            this.delegate.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        finally {
            LoggingConnection.getConnectionTracker().untrack(this);
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        String methodCall = "getUpdateCount()";
        try {
            return this.reportReturn(methodCall, this.delegate.getUpdateCount());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == Connection.class || iface == JdbcSpy.class) ? this : this.delegate.unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == Statement.class || iface == JdbcSpy.class) || this.delegate.isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

