/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.digitalforge.log4jdbc.util.Utilities;

public class PostLogProfilerProcessor {
    private long totalSql = 0L;
    private long lineNo = 0L;
    private long totalNanoSec = 0L;
    private long maxNanoSec = 0L;
    private long flaggedSqlTotalNanoSec = 0L;
    private long threshold = TimeUnit.MILLISECONDS.toNanos(100L);
    private long topOffenderCount = 1000L;
    private List flaggedSql = new LinkedList();

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("usage: java PostLogProfilerProcessor <log-file>");
            System.exit(1);
        }
        new PostLogProfilerProcessor(args[0], System.out);
    }

    public PostLogProfilerProcessor(String filename, PrintStream out) throws Exception {
        int flaggedSqlStmts;
        String line;
        FileReader f = new FileReader(filename);
        LineNumberReader l = new LineNumberReader(f);
        StringBuffer sql = new StringBuffer();
        do {
            if ((line = l.readLine()) == null) continue;
            boolean blankLine = line.length() == 0;
            ++this.lineNo;
            if (blankLine) {
                this.processSql(sql);
                sql = new StringBuffer();
                continue;
            }
            sql.append(line);
        } while (line != null);
        out.println("processed " + this.lineNo + " lines.");
        f.close();
        out.println("Number of sql statements:  " + this.totalSql);
        out.println("Total number of nanoseconds    :  " + this.totalNanoSec);
        if (this.totalNanoSec > 0L) {
            out.println("Average nanosecond/statement  :  " + this.totalSql / this.totalNanoSec);
        }
        if ((flaggedSqlStmts = this.flaggedSql.size()) > 0) {
            out.println("Sql statements that took more than " + this.threshold + " nanoseconds were flagged.");
            out.println("Flagged sql statements              :  " + flaggedSqlStmts);
            out.println("Flagged sql Total number of nanoseconds    :  " + this.flaggedSqlTotalNanoSec);
            out.println("Flagged sql Average nanosecond/statement  :  " + this.flaggedSqlTotalNanoSec / (long)flaggedSqlStmts);
            out.println("sorting...");
            Object[] flaggedSqlArray = this.flaggedSql.toArray();
            Arrays.sort(flaggedSqlArray);
            int execTimeSize = ("" + this.maxNanoSec).length();
            if (this.topOffenderCount > (long)flaggedSqlArray.length) {
                this.topOffenderCount = flaggedSqlArray.length;
            }
            out.println("top " + this.topOffenderCount + " offender" + (this.topOffenderCount == 1L ? "" : "s") + ":");
            int i = 0;
            while ((long)i < this.topOffenderCount) {
                ProfiledSql p = (ProfiledSql)flaggedSqlArray[i];
                out.println(Utilities.rightJustify(execTimeSize, "" + p.getExecTimeNanoSec()) + " " + p.getSql());
                ++i;
            }
        }
    }

    private void processSql(StringBuffer sql) {
        if (sql.length() > 0) {
            ++this.totalSql;
            String sqlStr = sql.toString();
            if (sqlStr.endsWith("nanoSec}")) {
                int executedIn = sqlStr.indexOf("{executed in ");
                if (executedIn == -1) {
                    System.err.println("WARNING:  sql w/o timing info found at line " + this.lineNo);
                    return;
                }
                String nanoSecStr = sqlStr.substring(executedIn + 13, sqlStr.length() - 9);
                long nanoSec = Long.parseLong(nanoSecStr);
                this.totalNanoSec += nanoSec;
                if (nanoSec > this.maxNanoSec) {
                    this.maxNanoSec = nanoSec;
                }
                if (nanoSec > this.threshold) {
                    this.flagSql(nanoSec, sqlStr);
                    this.flaggedSqlTotalNanoSec += nanoSec;
                }
            } else {
                System.err.println("WARNING:  sql w/o timing info found at line " + this.lineNo);
            }
        }
    }

    private void flagSql(long nanoSec, String sql) {
        this.flaggedSql.add(new ProfiledSql(nanoSec, sql));
    }

    private class ProfiledSql
    implements Comparable {
        private Long execTimeNanoSec;
        private String sql;

        public ProfiledSql(long nanoSec, String sql) {
            this.execTimeNanoSec = new Long(nanoSec);
            this.sql = sql;
        }

        public int compareTo(Object o) {
            return ((ProfiledSql)o).execTimeNanoSec.compareTo(this.execTimeNanoSec);
        }

        public Long getExecTimeNanoSec() {
            return this.execTimeNanoSec;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.execTimeNanoSec + " nanoseconds:  " + this.sql;
        }
    }
}

