/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Files {
    private static final Logger log = LoggerFactory.getLogger(Files.class);

    private Files() {
    }

    public static void copyFile(String fromFile, String toFile) throws IOException {
        try (FileInputStream in = new FileInputStream(fromFile);
             FileOutputStream out = new FileOutputStream(toFile);){
            int len;
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
    }

    public static String getShortFileName(String fileName) {
        String shortFileName = "";
        int pos = fileName.lastIndexOf(92);
        if (pos == -1) {
            pos = fileName.lastIndexOf(47);
        }
        shortFileName = pos > -1 ? fileName.substring(pos + 1) : fileName;
        return shortFileName;
    }

    public static String getShortFileNameWithoutExt(String fileName) {
        String shortFileName = Files.getShortFileName(fileName);
        shortFileName = Files.getFileNameWithoutExt(shortFileName);
        return shortFileName;
    }

    public static String read(String fileName) throws IOException {
        return Files.read(new File(fileName));
    }

    public static String read(File file) throws IOException {
        String fileContent = "";
        try (FileInputStream in = new FileInputStream(file);){
            fileContent = Files.read(in);
        }
        return fileContent;
    }

    public static String read(InputStream is) throws IOException {
        byte[] result = Files.readBytes(is);
        return new String(result, Charset.defaultCharset());
    }

    public static byte[] readBytes(String fileName) throws IOException {
        return Files.readBytes(new FileInputStream(fileName));
    }

    public static byte[] readBytes(File file) throws IOException {
        return Files.readBytes(new FileInputStream(file));
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        if (is == null || is.available() < 1) {
            return new byte[0];
        }
        byte[] buff = new byte[8192];
        byte[] result = new byte[is.available()];
        try (BufferedInputStream in = new BufferedInputStream(is);){
            int nch;
            int pos = 0;
            while ((nch = in.read(buff, 0, buff.length)) != -1) {
                System.arraycopy(buff, 0, result, pos, nch);
                pos += nch;
            }
        }
        return result;
    }

    public static void write(String content, File file) throws IOException {
        Files.write(content.getBytes(Charset.defaultCharset()), file);
    }

    public static void write(String content, String file) throws IOException {
        Files.write(content, new File(file));
    }

    public static void write(byte[] bytes, String file) throws IOException {
        Files.write(bytes, new File(file));
    }

    public static void write(byte[] bytes, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(bytes);
            out.flush();
        }
    }

    public static String getFileNameWithoutExt(String fileName) {
        String shortFileName = fileName;
        if (fileName.indexOf(46) > -1) {
            shortFileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return shortFileName;
    }

    public static String getFileNameExt(String fileName) {
        String fileExt = "";
        if (fileName.indexOf(46) > -1) {
            fileExt = fileName.substring(fileName.lastIndexOf(46));
        }
        return fileExt;
    }

    public static synchronized File getUniqueFile(File repository, String fileName) {
        String shortFileName = Files.getShortFileName(fileName);
        String tempFileName = Files.getFileNameWithoutExt(shortFileName);
        File file = new File(repository, shortFileName);
        String fileExt = Files.getFileNameExt(shortFileName);
        SecureRandom random = new SecureRandom();
        while (file.exists()) {
            file = new File(repository, tempFileName + "-" + random.nextInt() + fileExt);
        }
        return file;
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            Files.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        try {
            java.nio.file.Files.delete(file.toPath());
        }
        catch (IOException e) {
            log.warn("{}", (Throwable)e);
        }
        if (file.exists()) {
            file.deleteOnExit();
        }
    }

    public static File getUniqueFile(Class<?> cl, String extension) {
        int key = 0;
        URL url = cl.getResource(Files.getClassNameWithoutPackage(cl) + ".class");
        if (url != null) {
            key = url.getPath().hashCode();
        }
        String parentDir = System.getProperty("java.io.tmpdir");
        Files.validSecurePath(parentDir);
        return new File(parentDir, Files.getClassNameWithoutPackage(cl) + key + extension);
    }

    private static String getClassNameWithoutPackage(Class<?> cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        return className.substring(pos);
    }

    public static void validSecurePath(String filePath) {
        if (filePath.contains("..")) {
            throw new IllegalArgumentException("Unsafe path.");
        }
    }

    public static boolean deleteFolder(File delFolder) {
        boolean hasDeleted = true;
        File[] allFiles = delFolder.listFiles();
        for (int i = 0; i < allFiles.length && hasDeleted; ++i) {
            if (allFiles[i].isDirectory()) {
                hasDeleted = Files.deleteFolder(allFiles[i]);
                continue;
            }
            if (!allFiles[i].isFile()) continue;
            try {
                java.nio.file.Files.delete(allFiles[i].toPath());
                continue;
            }
            catch (IOException | SecurityException e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
                hasDeleted = false;
            }
        }
        if (hasDeleted) {
            try {
                java.nio.file.Files.delete(delFolder.toPath());
            }
            catch (IOException e) {
                hasDeleted = false;
                log.warn("{}", (Throwable)e);
            }
        }
        return hasDeleted;
    }

    public static String getRealPathName(Class<?> cl) {
        URL url = cl.getResource(Files.getClassNameWithoutPackage(cl) + ".class");
        if (url != null) {
            return url.getPath();
        }
        return null;
    }

    public static void createJarArchive(File archiveFile, File[] tobeJared) throws IOException {
        byte[] buffer = new byte[1024];
        try (FileOutputStream stream = new FileOutputStream(archiveFile);
             JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());){
            block27: for (int i = 0; i < tobeJared.length; ++i) {
                if (tobeJared[i] == null || !tobeJared[i].exists() || tobeJared[i].isDirectory()) continue;
                JarEntry jarAdd = new JarEntry(tobeJared[i].getName());
                jarAdd.setTime(tobeJared[i].lastModified());
                out.putNextEntry(jarAdd);
                try (FileInputStream in = new FileInputStream(tobeJared[i]);){
                    while (true) {
                        int nRead;
                        if ((nRead = in.read(buffer, 0, buffer.length)) <= 0) {
                            continue block27;
                        }
                        out.write(buffer, 0, nRead);
                    }
                }
            }
        }
    }
}

