/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Generics {
    private static final Logger log = LoggerFactory.getLogger(Generics.class);

    private Generics() {
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz) {
        return Generics.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.debug("{}'s superclass not ParameterizedType", (Object)clazz.getSimpleName());
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn("Index: {}, Size of {}'s Parameterized Type: {}", new Object[]{index, clazz.getSimpleName(), params.length});
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn("{} not set the actual class on superclass generic parameter", (Object)clazz.getSimpleName());
            return Object.class;
        }
        return (Class)params[index];
    }
}

