/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.filter.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest orgRequest;

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.orgRequest = request;
    }

    public String getParameter(String name) {
        String value = super.getParameter(XssHttpServletRequestWrapper.xssEncode(name));
        if (value != null) {
            value = XssHttpServletRequestWrapper.xssEncode(value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(XssHttpServletRequestWrapper.xssEncode(name));
        if (value != null) {
            value = XssHttpServletRequestWrapper.xssEncode(value);
        }
        return value;
    }

    private static String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block9;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block9;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block9;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block9;
                }
                case '&': {
                    sb.append('\uff06');
                    continue block9;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block9;
                }
                case '#': {
                    sb.append('\uff03');
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getOrgRequest();
        }
        return req;
    }
}

