/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class JwtUtil
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    private static final int MILLISECOND = 1000;
    private static final long serialVersionUID = -3301605591108950415L;
    private static final String CLAIM_KEY_USERCODE = "userCode";
    private static final String CLAIM_KEY_USERNAME = "userName";
    private static final String CLAIM_KEY_CREATED = "created";
    @Value(value="${jwt.secret:arch6Secret}")
    public String secret;
    @Value(value="${jwt.header:Authorization}")
    public String header;
    @Value(value="${jwt.expiration:86400}")
    public Long expiration;
    @Value(value="${jwt.tokenHead:Arch6WithCloud}")
    public String tokenHead;

    public Object getAttribute(String attribute) {
        HttpServletRequest req = JwtUtil.getHttpServletRequest();
        String authHeader = req.getHeader(this.header);
        String authToken = authHeader.substring(this.tokenHead.length());
        Claims claims = this.getClaimsFromToken(authToken);
        return claims.get((Object)attribute);
    }

    public String getUserCode() {
        HttpServletRequest req = JwtUtil.getHttpServletRequest();
        String authHeader = req.getHeader(this.header);
        String authToken = authHeader.substring(this.tokenHead.length());
        return this.getUserCodeFromToken(authToken);
    }

    public String getUserCodeFromToken(String token) {
        String username;
        try {
            Claims claims = this.getClaimsFromToken(token);
            username = (String)claims.get((Object)CLAIM_KEY_USERCODE);
        }
        catch (Exception e) {
            username = null;
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return username;
    }

    public String getUsernameFromToken(String token) {
        String username;
        try {
            Claims claims = this.getClaimsFromToken(token);
            username = (String)claims.get((Object)CLAIM_KEY_USERNAME);
        }
        catch (Exception e) {
            username = null;
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return username;
    }

    private Date getCreatedDateFromToken(String token) {
        Date created;
        try {
            Claims claims = this.getClaimsFromToken(token);
            created = new Date((Long)claims.get((Object)CLAIM_KEY_CREATED));
        }
        catch (Exception e) {
            created = null;
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return created;
    }

    private Date getExpirationDateFromToken(String token) {
        Date expirationDate;
        try {
            Claims claims = this.getClaimsFromToken(token);
            expirationDate = claims.getExpiration();
        }
        catch (Exception e) {
            expirationDate = null;
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return expirationDate;
    }

    private Claims getClaimsFromToken(String token) {
        DefaultClaims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = new DefaultClaims();
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return claims;
    }

    private Date generateExpirationDate() {
        return new Date(System.currentTimeMillis() + this.expiration * 1000L);
    }

    private Boolean isTokenExpired(String token) {
        Date expirationDate = this.getExpirationDateFromToken(token);
        if (expirationDate == null) {
            return false;
        }
        return expirationDate.before(new Date());
    }

    private static Boolean isCreatedBeforeLastPasswordReset(Date created, Date lastPasswordReset) {
        return lastPasswordReset != null && created.before(lastPasswordReset);
    }

    private String generateToken(Map<String, Object> claims) {
        return Jwts.builder().setClaims(claims).setExpiration(this.generateExpirationDate()).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public Boolean canTokenBeRefreshed(String token, Date lastPasswordReset) {
        Date created = this.getCreatedDateFromToken(token);
        return JwtUtil.isCreatedBeforeLastPasswordReset(created, lastPasswordReset) == false && this.isTokenExpired(token) == false;
    }

    public String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = this.getClaimsFromToken(token);
            claims.put((Object)CLAIM_KEY_CREATED, (Object)new Date());
            refreshedToken = this.generateToken((Map<String, Object>)claims);
        }
        catch (Exception e) {
            refreshedToken = null;
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return refreshedToken;
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public String getSecret() {
        return this.secret;
    }

    public String getHeader() {
        return this.header;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    public String getTokenHead() {
        return this.tokenHead;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setExpiration(Long expiration) {
        this.expiration = expiration;
    }

    public void setTokenHead(String tokenHead) {
        this.tokenHead = tokenHead;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtUtil)) {
            return false;
        }
        JwtUtil other = (JwtUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Long this$expiration = this.getExpiration();
        Long other$expiration = other.getExpiration();
        if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
            return false;
        }
        String this$tokenHead = this.getTokenHead();
        String other$tokenHead = other.getTokenHead();
        return !(this$tokenHead == null ? other$tokenHead != null : !this$tokenHead.equals(other$tokenHead));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Long $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        String $tokenHead = this.getTokenHead();
        result = result * 59 + ($tokenHead == null ? 43 : $tokenHead.hashCode());
        return result;
    }

    public String toString() {
        return "JwtUtil(secret=" + this.getSecret() + ", header=" + this.getHeader() + ", expiration=" + this.getExpiration() + ", tokenHead=" + this.getTokenHead() + ")";
    }
}

