/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);
    public static final ThreadLocal<ServletRequest> store = new ThreadLocal();

    private RequestUtils() {
    }

    public static Map<String, String> convertToMap(HttpServletRequest request) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            paramMap.put(name, request.getParameter(name));
        }
        return paramMap;
    }

    public static int getInt(Map<String, String[]> paramMap, String paramName, int defaultValue) {
        String[] paramValue = paramMap.get(paramName);
        int value = defaultValue;
        try {
            if (paramValue != null && paramValue.length > 0) {
                value = Integer.valueOf(paramValue[0]);
            }
        }
        catch (NumberFormatException e) {
            log.debug("{}", (Throwable)e);
        }
        return value;
    }

    public static String getString(Map<String, String[]> paramMap, String paramName, String defaultValue) {
        String[] paramValue = paramMap.get(paramName);
        String value = defaultValue;
        try {
            if (paramValue != null && paramValue.length > 0) {
                value = paramValue[0];
            }
        }
        catch (Exception e) {
            value = defaultValue;
            log.debug("{}", (Object)e.getMessage(), (Object)e);
        }
        return value;
    }

    public static void setRequest(ServletRequest request) {
        store.set(request);
        log.debug("ThreadLocal store request,IP={}", (Object)request.getRemoteAddr());
    }

    public static HttpServletRequest getRequest() {
        ServletRequest request = store.get();
        if (request == null) {
            return null;
        }
        return (HttpServletRequest)request;
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }
}

