/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.TextEmbeddingTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;

public class TextEmbeddingBatchTranslator
implements NoBatchifyTranslator<String[], float[][]> {
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private boolean normalize;
    private String pooling;

    TextEmbeddingBatchTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier, String pooling, boolean normalize) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
        this.pooling = pooling;
        this.normalize = normalize;
    }

    public NDList processInput(TranslatorContext ctx, String[] input) {
        NDManager manager = ctx.getNDManager();
        Encoding[] encodings = this.tokenizer.batchEncode(input);
        ctx.setAttachment("encodings", (Object)encodings);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, false);
        }
        return this.batchifier.batchify(batch);
    }

    public float[][] processOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        Encoding[] encoding = (Encoding[])ctx.getAttachment("encodings");
        NDManager manager = ctx.getNDManager();
        float[][] ret = new float[batch.length][];
        for (int i = 0; i < batch.length; ++i) {
            NDArray array = TextEmbeddingTranslator.processEmbedding(manager, batch[i], encoding[i], this.pooling);
            if (this.normalize) {
                array = array.normalize(2.0, 0L);
            }
            ret[i] = array.toFloatArray();
        }
        return ret;
    }
}

