/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.maven.plugins.provisio;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.provis.Actions;
import io.provis.model.Runtime;
import io.provis.model.io.RuntimeReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.FileUtils;

@Named
@Singleton
public class Provisio {
    private final ArtifactHandlerManager artifactHandlerManager;

    @Inject
    public Provisio(ArtifactHandlerManager artifactHandlerManager) {
        this.artifactHandlerManager = artifactHandlerManager;
    }

    public List<Runtime> findDescriptors(File descriptorDirectory, MavenProject project) {
        ArrayList runtimes = Lists.newArrayList();
        runtimes.addAll(this.findDescriptorsInFileSystem(descriptorDirectory, project));
        runtimes.addAll(this.findDescriptorsForPackagingTypeInExtensionRealms(project));
        return runtimes;
    }

    public List<Runtime> findDescriptorsInFileSystem(File descriptorDirectory, MavenProject project) {
        ArrayList runtimes = Lists.newArrayList();
        if (descriptorDirectory.exists()) {
            try {
                List descriptors = FileUtils.getFiles((File)descriptorDirectory, (String)"*.xml", null);
                for (File descriptor : descriptors) {
                    Runtime runtime = this.parseDescriptor(new FileInputStream(descriptor), project);
                    runtimes.add(runtime);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error parsing provisioning descriptors in %s.", descriptorDirectory), e);
            }
        }
        return runtimes;
    }

    public List<Runtime> findDescriptorsForPackagingTypeInExtensionRealms(MavenProject project) {
        Collection extensionRealms;
        ArrayList runtimes = Lists.newArrayList();
        if (project.getClassRealm() != null && (extensionRealms = project.getClassRealm().getImportRealms()) != null) {
            for (ClassRealm extensionRealm : extensionRealms) {
                String descriptorResourceLocation;
                InputStream inputStream = extensionRealm.getResourceAsStream(descriptorResourceLocation = String.format("META-INF/provisio/%s.xml", project.getPackaging()));
                if (inputStream == null) continue;
                Runtime runtime = this.parseDescriptor(inputStream, project);
                runtimes.add(runtime);
            }
        }
        return runtimes;
    }

    public Runtime parseDescriptor(InputStream inputStream, MavenProject project) {
        RuntimeReader parser = new RuntimeReader(Actions.defaultActionDescriptors(), this.versionMap(project));
        HashMap variables = Maps.newHashMap();
        variables.putAll(project.getProperties());
        variables.put("project.version", project.getVersion());
        variables.put("project.groupId", project.getGroupId());
        variables.put("project.artifactId", project.getArtifactId());
        variables.put("basedir", project.getBasedir().getAbsolutePath());
        return parser.read(inputStream, (Map)variables);
    }

    private Map<String, String> versionMap(MavenProject project) {
        HashMap versionMap = Maps.newHashMap();
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency managedDependency : project.getDependencyManagement().getDependencies()) {
                String versionlessCoordinate = this.toVersionlessCoordinate(managedDependency);
                versionMap.put(versionlessCoordinate, managedDependency.getVersion());
            }
        }
        versionMap.put(this.toVersionlessCoordinate(project), project.getVersion());
        return versionMap;
    }

    public List<String> getManagedDependencies(MavenProject project) {
        ArrayList managedDependencies = Lists.newArrayList();
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency managedDependency : project.getDependencyManagement().getDependencies()) {
                managedDependencies.add(this.toCoordinate(managedDependency));
            }
        }
        return managedDependencies;
    }

    public String toCoordinate(Dependency d) {
        StringBuffer sb = new StringBuffer().append(d.getGroupId()).append(":").append(d.getArtifactId()).append(":").append(d.getType());
        if (d.getClassifier() != null && !d.getClassifier().isEmpty()) {
            sb.append(":").append(d.getClassifier());
        }
        sb.append(":").append(d.getVersion());
        return sb.toString();
    }

    public String toVersionlessCoordinate(Dependency d) {
        StringBuffer sb = new StringBuffer().append(d.getGroupId()).append(":").append(d.getArtifactId()).append(":").append(d.getType());
        if (d.getClassifier() != null && !d.getClassifier().isEmpty()) {
            sb.append(":").append(d.getClassifier());
        }
        return sb.toString();
    }

    public String toVersionlessCoordinate(MavenProject project) {
        String extension = this.artifactHandlerManager.getArtifactHandler(project.getPackaging()).getExtension();
        StringBuffer sb = new StringBuffer().append(project.getGroupId()).append(":").append(project.getArtifactId()).append(":").append(extension);
        return sb.toString();
    }
}

