/*
 * Decompiled with CFR 0.152.
 */
package ch.mfrey.thymeleaf.extras.with;

import org.attoparser.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.element.IElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.EscapedAttributeUtils;

public class WithProcessor
extends AbstractProcessor
implements IElementTagProcessor {
    private static final Logger log = LoggerFactory.getLogger(WithProcessor.class);
    public static final int PRECEDENCE = 600;
    private final String dialectPrefix;
    private final MatchingAttributeName matchingAttributeName;

    public WithProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, 600);
        this.dialectPrefix = dialectPrefix;
        this.matchingAttributeName = MatchingAttributeName.forAllAttributesWithPrefix((TemplateMode)this.getTemplateMode(), (String)dialectPrefix);
    }

    public final MatchingAttributeName getMatchingAttributeName() {
        return this.matchingAttributeName;
    }

    public final MatchingElementName getMatchingElementName() {
        return null;
    }

    public void process(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        TemplateMode templateMode = context.getTemplateMode();
        IAttribute[] attributes = tag.getAllAttributes();
        IEngineContext engineContext = context instanceof IEngineContext ? (IEngineContext)context : null;
        for (IAttribute attribute : attributes) {
            AttributeName attributeName = attribute.getAttributeDefinition().getAttributeName();
            String completeName = attribute.getAttributeCompleteName();
            String newVariableName = completeName.substring(completeName.length() - attributeName.getAttributeName().length());
            if (!attributeName.isPrefixed() || !TextUtil.equals((boolean)templateMode.isCaseSensitive(), (CharSequence)attributeName.getPrefix(), (CharSequence)this.dialectPrefix)) continue;
            this.processWithAttribute(context, engineContext, tag, attribute, attributeName, newVariableName, structureHandler);
        }
    }

    private void processWithAttribute(ITemplateContext context, IEngineContext engineContext, IProcessableElementTag tag, IAttribute attribute, AttributeName attributeName, String newVariableName, IElementTagStructureHandler structureHandler) {
        try {
            Object expressionResult;
            String attributeValue = EscapedAttributeUtils.unescapeAttribute((TemplateMode)context.getTemplateMode(), (String)attribute.getValue());
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)context.getConfiguration());
            if (attributeValue != null) {
                IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)context, attributeValue);
                expressionResult = expression.execute((IExpressionContext)context);
            } else {
                expressionResult = null;
            }
            log.debug("Setting Variable: {}={}", (Object)newVariableName, expressionResult);
            if (engineContext != null) {
                engineContext.setVariable(newVariableName, expressionResult);
            } else {
                structureHandler.setLocalVariable(newVariableName, expressionResult);
            }
            structureHandler.removeAttribute(attributeName);
        }
        catch (TemplateProcessingException e) {
            if (!e.hasTemplateName()) {
                e.setTemplateName(tag.getTemplateName());
            }
            if (!e.hasLineAndCol()) {
                e.setLineAndCol(attribute.getLine(), attribute.getCol());
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + WithProcessor.class.getName() + "'", tag.getTemplateName(), attribute.getLine(), attribute.getCol(), (Throwable)e);
        }
    }
}

