/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.httpauth.digest;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.SaCheckHttpDigest;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.exception.NotHttpDigestAuthException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.httpauth.digest.SaHttpDigestModel;
import cn.dev33.satoken.secure.SaSecureUtil;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.LinkedHashMap;

public class SaHttpDigestTemplate {
    public String buildResponseHeaderValue(SaHttpDigestModel model) {
        String headerValue = "Digest realm=\"" + model.realm + "\", qop=\"" + model.qop + "\", nonce=\"" + model.nonce + "\", nc=" + model.nc + ", opaque=\"" + model.opaque + "\"";
        return headerValue;
    }

    public void throwNotHttpDigestAuthException(SaHttpDigestModel model) {
        model.realm = model.realm != null ? model.realm : "Sa-Token";
        model.qop = model.qop != null ? model.qop : "auth";
        model.nonce = model.nonce != null ? model.nonce : SaFoxUtil.getRandomString(32);
        model.opaque = model.opaque != null ? model.opaque : SaFoxUtil.getRandomString(32);
        model.nc = model.nc != null ? model.nc : "00000001";
        SaHolder.getResponse().setStatus(401).setHeader("WWW-Authenticate", this.buildResponseHeaderValue(model));
        throw new NotHttpDigestAuthException().setCode(10312);
    }

    public String getAuthorizationValue() {
        String authorization = SaHolder.getRequest().getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Digest ")) {
            return null;
        }
        return authorization.substring(7);
    }

    public SaHttpDigestModel getAuthorizationValueToModel() {
        String[] arr;
        String authorization = this.getAuthorizationValue();
        if (authorization == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String s : arr = authorization.split(",")) {
            String[] kv = s.split("=");
            if (kv.length != 2) continue;
            map.put(kv[0].trim(), kv[1].trim().replace("\"", ""));
        }
        SaHttpDigestModel model = new SaHttpDigestModel();
        model.username = (String)map.get("username");
        model.realm = (String)map.get("realm");
        model.nonce = (String)map.get("nonce");
        model.uri = (String)map.get("uri");
        model.method = SaHolder.getRequest().getMethod();
        model.qop = (String)map.get("qop");
        model.nc = (String)map.get("nc");
        model.cnonce = (String)map.get("cnonce");
        model.opaque = (String)map.get("opaque");
        model.response = (String)map.get("response");
        return model;
    }

    public String calcResponse(SaHttpDigestModel model) {
        String frag1 = SaSecureUtil.md5(model.username + ":" + model.realm + ":" + model.password);
        String frag2 = model.nonce + ":" + model.nc + ":" + model.cnonce + ":" + model.qop;
        String frag3 = SaSecureUtil.md5(model.method + ":" + model.uri);
        String response = SaSecureUtil.md5(frag1 + ":" + frag2 + ":" + frag3);
        return response;
    }

    public void copyHopeToReq(SaHttpDigestModel hopeModel, SaHttpDigestModel reqModel) {
        reqModel.username = hopeModel.username;
        reqModel.password = hopeModel.password;
        reqModel.realm = hopeModel.realm != null ? hopeModel.realm : reqModel.realm;
        reqModel.nonce = hopeModel.nonce != null ? hopeModel.nonce : reqModel.nonce;
        reqModel.uri = hopeModel.uri != null ? hopeModel.uri : reqModel.uri;
        reqModel.method = hopeModel.method != null ? hopeModel.method : reqModel.method;
        reqModel.qop = hopeModel.qop != null ? hopeModel.qop : reqModel.qop;
        reqModel.nc = hopeModel.nc != null ? hopeModel.nc : reqModel.nc;
        reqModel.opaque = hopeModel.opaque != null ? hopeModel.opaque : reqModel.opaque;
    }

    public void check(SaHttpDigestModel hopeModel) {
        SaTokenException.notEmpty(hopeModel, "Digest\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        SaTokenException.notEmpty(hopeModel.username, "\u5fc5\u987b\u63d0\u4f9b\u5e0c\u671b\u7684 username \u53c2\u6570");
        SaTokenException.notEmpty(hopeModel.password, "\u5fc5\u987b\u63d0\u4f9b\u5e0c\u671b\u7684 password \u53c2\u6570");
        SaHttpDigestModel reqModel = this.getAuthorizationValueToModel();
        if (reqModel == null) {
            this.throwNotHttpDigestAuthException(hopeModel);
        }
        this.copyHopeToReq(hopeModel, reqModel);
        String cResponse = this.calcResponse(reqModel);
        if (!cResponse.equals(reqModel.response)) {
            this.throwNotHttpDigestAuthException(hopeModel);
        }
    }

    public void check(String username, String password) {
        this.check(new SaHttpDigestModel(username, password));
    }

    public void check(String username, String password, String realm) {
        this.check(new SaHttpDigestModel(username, password, realm));
    }

    public void check() {
        String httpDigest = SaManager.getConfig().getHttpDigest();
        if (SaFoxUtil.isEmpty(httpDigest)) {
            throw new SaTokenException("\u672a\u914d\u7f6e\u5168\u5c40 Http Digest \u8ba4\u8bc1\u53c2\u6570");
        }
        String[] arr = httpDigest.split(":");
        if (arr.length != 2) {
            throw new SaTokenException("\u5168\u5c40 Http Digest \u8ba4\u8bc1\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u683c\u5f0f\u5e94\u5982\uff1ausername:password");
        }
        this.check(arr[0], arr[1]);
    }

    public void checkByAnnotation(SaCheckHttpDigest at) {
        String value = at.value();
        if (SaFoxUtil.isNotEmpty(value)) {
            String[] arr = value.split(":");
            if (arr.length != 2) {
                throw new SaTokenException("\u6ce8\u89e3\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u683c\u5f0f\u5e94\u5982\uff1ausername:password");
            }
            this.check(arr[0], arr[1]);
            return;
        }
        String username = at.username();
        if (SaFoxUtil.isNotEmpty(username)) {
            this.check(username, at.password(), at.realm());
            return;
        }
        this.check();
    }
}

