/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.tracer.core.aop;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.iocoder.yudao.framework.common.util.spring.SpringExpressionUtils;
import cn.iocoder.yudao.framework.tracer.core.annotation.BizTrace;
import cn.iocoder.yudao.framework.tracer.core.util.TracerFrameworkUtils;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class BizTraceAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BizTraceAspect.class);
    private static final String BIZ_OPERATION_NAME_PREFIX = "Biz/";
    private final Tracer tracer;

    @Around(value="@annotation(trace)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, BizTrace bizTrace) throws Throwable {
        String string = this.getOperationName(proceedingJoinPoint, bizTrace);
        Span span = this.tracer.buildSpan(string).withTag(Tags.COMPONENT.getKey(), "biz").start();
        try {
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        catch (Throwable throwable) {
            TracerFrameworkUtils.onError(throwable, span);
            throw throwable;
        }
        finally {
            this.setBizTag(span, proceedingJoinPoint, bizTrace);
            span.finish();
        }
    }

    private String getOperationName(ProceedingJoinPoint proceedingJoinPoint, BizTrace bizTrace) {
        if (StrUtil.isNotEmpty((CharSequence)bizTrace.operationName())) {
            return BIZ_OPERATION_NAME_PREFIX + bizTrace.operationName();
        }
        return BIZ_OPERATION_NAME_PREFIX + proceedingJoinPoint.getSignature().getDeclaringType().getSimpleName() + "/" + proceedingJoinPoint.getSignature().getName();
    }

    private void setBizTag(Span span, ProceedingJoinPoint proceedingJoinPoint, BizTrace bizTrace) {
        try {
            Map map = SpringExpressionUtils.parseExpressions((JoinPoint)proceedingJoinPoint, Arrays.asList(bizTrace.type(), bizTrace.id()));
            span.setTag("biz.type", MapUtil.getStr((Map)map, (Object)bizTrace.type()));
            span.setTag("biz.id", MapUtil.getStr((Map)map, (Object)bizTrace.id()));
        }
        catch (Exception exception) {
            log.error("[setBizTag][\u89e3\u6790 bizType \u4e0e bizId \u53d1\u751f\u5f02\u5e38]", (Throwable)exception);
        }
    }

    @Generated
    public BizTraceAspect(Tracer tracer) {
        this.tracer = tracer;
    }
}

