/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.tracer.core.util;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class TracerFrameworkUtils {
    public static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        if (throwable != null) {
            span.log(TracerFrameworkUtils.errorLogs(throwable));
        }
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("event", Tags.ERROR.getKey());
        hashMap.put("error.object", throwable);
        hashMap.put("error.kind", throwable.getClass().getName());
        String string2 = string = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
        if (string != null) {
            hashMap.put("message", string);
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        hashMap.put("stack", stringWriter.toString());
        return hashMap;
    }
}

