/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.gson;

import cn.zhxu.data.Array;
import cn.zhxu.data.DataConvertor;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.gson.GsonArray;
import cn.zhxu.data.gson.GsonList;
import cn.zhxu.data.gson.GsonMap;
import cn.zhxu.data.gson.GsonMapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class GsonDataConvertor
implements DataConvertor {
    private Gson gson;

    public GsonDataConvertor() {
        this(new Gson());
    }

    public GsonDataConvertor(Gson gson) {
        this.gson = gson;
    }

    public Mapper toMapper(InputStream in, Charset charset) {
        return new GsonMapper(this.gson, (JsonObject)this.gson.fromJson((Reader)new InputStreamReader(in, charset), JsonObject.class));
    }

    public Mapper toMapper(String in) {
        return new GsonMapper(this.gson, (JsonObject)this.gson.fromJson(in, JsonObject.class));
    }

    public Array toArray(InputStream in, Charset charset) {
        return new GsonArray(this.gson, (JsonArray)this.gson.fromJson((Reader)new InputStreamReader(in, charset), JsonArray.class));
    }

    public Array toArray(String in) {
        return new GsonArray(this.gson, (JsonArray)this.gson.fromJson(in, JsonArray.class));
    }

    public byte[] serialize(Object object, Charset charset) {
        return this.serialize(object).getBytes(charset);
    }

    public String serialize(Object object) {
        if (object instanceof GsonMapper || object instanceof GsonArray) {
            return object.toString();
        }
        return this.gson.toJson(object);
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(in, charset), type);
    }

    public <T> T toBean(Type type, String in) {
        return (T)this.gson.fromJson(in, type);
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        Object[] beans = (Object[])this.gson.fromJson((Reader)new InputStreamReader(in, charset), TypeToken.getArray(type).getType());
        return Arrays.asList(beans);
    }

    public <T> List<T> toList(Class<T> type, String in) {
        Object[] beans = (Object[])this.gson.fromJson(in, TypeToken.getArray(type).getType());
        return Arrays.asList(beans);
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public static Object toPlainObject(JsonElement value) {
        if (value != null) {
            if (value.isJsonObject()) {
                return new GsonMap((JsonObject)value);
            }
            if (value.isJsonArray()) {
                return new GsonList((JsonArray)value);
            }
            if (value.isJsonPrimitive()) {
                JsonPrimitive p = (JsonPrimitive)value;
                if (p.isBoolean()) {
                    return p.getAsBoolean();
                }
                if (p.isString()) {
                    return p.getAsString();
                }
                if (p.isNumber()) {
                    Number num = p.getAsNumber();
                    if (num instanceof Integer || num instanceof Long || num instanceof Double || num instanceof Float || num instanceof Short || num instanceof Byte) {
                        return num;
                    }
                    String str = num.toString();
                    if (str.indexOf(46) >= 0) {
                        if (str.length() > 8) {
                            return Double.parseDouble(str);
                        }
                        return Float.valueOf(Float.parseFloat(str));
                    }
                    if (str.length() > 8) {
                        return Long.parseLong(str);
                    }
                    return Integer.parseInt(str);
                }
            }
        }
        return null;
    }
}

