/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AutoscalingResources
implements JsonpSerializable {
    private final int storage;
    private final int memory;
    public static final JsonpDeserializer<AutoscalingResources> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoscalingResources::setupAutoscalingResourcesDeserializer);

    private AutoscalingResources(Builder builder) {
        this.storage = ApiTypeHelper.requireNonNull(builder.storage, this, "storage");
        this.memory = ApiTypeHelper.requireNonNull(builder.memory, this, "memory");
    }

    public static AutoscalingResources of(Function<Builder, ObjectBuilder<AutoscalingResources>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int storage() {
        return this.storage;
    }

    public final int memory() {
        return this.memory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("storage");
        generator.write(this.storage);
        generator.writeKey("memory");
        generator.write(this.memory);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAutoscalingResourcesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::storage, JsonpDeserializer.integerDeserializer(), "storage");
        op.add(Builder::memory, JsonpDeserializer.integerDeserializer(), "memory");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AutoscalingResources> {
        private Integer storage;
        private Integer memory;

        public final Builder storage(int value) {
            this.storage = value;
            return this;
        }

        public final Builder memory(int value) {
            this.memory = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoscalingResources build() {
            this._checkSingleUse();
            return new AutoscalingResources(this);
        }
    }
}

