/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.cs;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.cs.CsConfiguration;
import com.alibaba.cloud.context.cs.CsHandledConfiguration;
import com.alibaba.cloud.context.cs.SimpleCsHandledConfiguration;
import com.alibaba.cloud.context.edas.AliCloudEdasSdk;
import com.alibaba.cloud.context.edas.AliCloudEdasSdkFactory;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfigurationFactory;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.utils.StringUtils;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import com.aliyuncs.edas.model.v20170801.InsertApplicationResponse;
import com.taobao.config.client.PublisherRegistration;
import com.taobao.config.client.SubscriberRegistration;
import com.taobao.config.client.bean.InstanceMetaData;

public class AliCloudCsInitializer {
    private AliCloudCsInitializer() {
    }

    public static void initialize(CsHandledConfiguration csHandledConfiguration, PublisherRegistration<String> registration) {
        AliCloudCsInitializer.initialize(csHandledConfiguration, registration, null);
    }

    public static void initialize(CsHandledConfiguration csHandledConfiguration, SubscriberRegistration registration) {
        AliCloudCsInitializer.initialize(csHandledConfiguration, null, registration);
    }

    private static void initialize(CsHandledConfiguration csHandledConfiguration, PublisherRegistration<String> publisherRegistration, SubscriberRegistration subscriberRegistration) {
        if (csHandledConfiguration.getServerMode() == AliCloudServerMode.EDAS) {
            InstanceMetaData instanceMetaData = new InstanceMetaData(csHandledConfiguration.getProjectName(), csHandledConfiguration.getDauthAccessKey(), csHandledConfiguration.getDauthSecretKey());
            if (publisherRegistration != null) {
                publisherRegistration.setTenant(csHandledConfiguration.getTenantId());
                publisherRegistration.setInstanceMetaData(instanceMetaData);
            }
            if (subscriberRegistration != null) {
                subscriberRegistration.setTenant(csHandledConfiguration.getTenantId());
                subscriberRegistration.setInstanceMetaData(instanceMetaData);
            }
        } else {
            InstanceMetaData instanceMetaData = new InstanceMetaData(csHandledConfiguration.getProjectName(), csHandledConfiguration.getDauthAccessKey(), csHandledConfiguration.getDauthSecretKey());
            if (publisherRegistration != null) {
                publisherRegistration.setInstanceMetaData(instanceMetaData);
                if (!StringUtils.isEmpty(csHandledConfiguration.getServerList())) {
                    publisherRegistration.setLocalAttribute("!Server", (Object)(csHandledConfiguration.getServerList() + "?key=default"));
                }
            }
            if (subscriberRegistration != null) {
                subscriberRegistration.setInstanceMetaData(instanceMetaData);
                if (!StringUtils.isEmpty(csHandledConfiguration.getServerList())) {
                    subscriberRegistration.setLocalAttribute("!Server", (Object)(csHandledConfiguration.getServerList() + "?key=default"));
                }
            }
        }
    }

    public static CsHandledConfiguration handleCsConfiguration(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, CsConfiguration csConfiguration) {
        return AliCloudCsInitializer.handleCsConfiguration(aliCloudConfiguration, edasConfiguration, csConfiguration, null);
    }

    public static CsHandledConfiguration handleCsConfiguration(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, CsConfiguration csConfiguration, AliCloudEdasSdk aliCloudEdasSdk) {
        SimpleCsHandledConfiguration csHandledConfiguration = new SimpleCsHandledConfiguration();
        EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory.getEdasChangeOrderConfiguration();
        if (edasChangeOrderConfiguration.isEdasManaged()) {
            csHandledConfiguration.setDauthAccessKey(edasChangeOrderConfiguration.getDauthAccessKey());
            csHandledConfiguration.setDauthSecretKey(edasChangeOrderConfiguration.getDauthSecretKey());
            csHandledConfiguration.setTenantId(edasChangeOrderConfiguration.getTenantId());
            csHandledConfiguration.setProjectName(edasChangeOrderConfiguration.getProjectName());
            csHandledConfiguration.setServerMode(AliCloudServerMode.EDAS);
        } else if (edasConfiguration.isEnabled() || csConfiguration.getServerMode() == AliCloudServerMode.EDAS) {
            if (aliCloudEdasSdk == null) {
                aliCloudEdasSdk = AliCloudEdasSdkFactory.getDefaultAliCloudEdasSdk(aliCloudConfiguration, edasConfiguration.getRegionId());
            }
            GetSecureTokenResponse.SecureToken secureToken = aliCloudEdasSdk.getSecureToken(edasConfiguration.getNamespace());
            InsertApplicationResponse.ApplicationInfo applicationInfo = aliCloudEdasSdk.getApplicationInfo(edasConfiguration.getApplicationName(), edasConfiguration.getNamespace());
            csHandledConfiguration.setDauthAccessKey(secureToken.getAccessKey());
            csHandledConfiguration.setDauthSecretKey(secureToken.getSecretKey());
            csHandledConfiguration.setTenantId(secureToken.getTenantId());
            csHandledConfiguration.setProjectName(applicationInfo.getAppId());
            csHandledConfiguration.setServerMode(AliCloudServerMode.EDAS);
            System.setProperty("configserver.client.port", "8000");
            System.setProperty("address.server.domain", secureToken.getAddressServerHost());
        } else {
            csHandledConfiguration.setServerList(csConfiguration.getServerList());
            csHandledConfiguration.setServerPort(csConfiguration.getServerPort());
            csHandledConfiguration.setServerMode(AliCloudServerMode.LOCAL);
        }
        if (null != csHandledConfiguration.getServerPort()) {
            System.setProperty("configserver.client.port", csHandledConfiguration.getServerPort());
        }
        return csHandledConfiguration;
    }
}

