/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCreateViewStatement
extends SQLStatementImpl
implements SQLDDLStatement {
    private boolean orReplace = false;
    protected SQLName name;
    protected SQLSelect subQuery;
    protected boolean ifNotExists = false;
    protected final List<Column> columns = new ArrayList<Column>();
    private Level with;
    private SQLLiteralExpr comment;

    public SQLCreateViewStatement() {
    }

    public SQLCreateViewStatement(String dbType) {
        super(dbType);
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public SQLName getName() {
        return this.name;
    }

    public void setName(SQLName name) {
        this.name = name;
    }

    public Level getWith() {
        return this.with;
    }

    public void setWith(Level with) {
        this.with = with;
    }

    public SQLSelect getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(SQLSelect subQuery) {
        this.subQuery = subQuery;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public SQLLiteralExpr getComment() {
        return this.comment;
    }

    public void setComment(SQLLiteralExpr comment) {
        if (comment != null) {
            comment.setParent(this);
        }
        this.comment = comment;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append("CREATE VIEW ");
        this.name.output(buf);
        if (this.columns.size() > 0) {
            buf.append(" (");
            int size = this.columns.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                this.columns.get(i).output(buf);
            }
            buf.append(")");
        }
        buf.append(" AS ");
        this.subQuery.output(buf);
        if (this.with != null) {
            buf.append(" WITH ");
            buf.append(this.with.name());
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.name);
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.comment);
            this.acceptChild(visitor, this.subQuery);
        }
        visitor.endVisit(this);
    }

    public static class Column
    extends SQLObjectImpl {
        private SQLExpr expr;
        private SQLCharExpr comment;

        public SQLExpr getExpr() {
            return this.expr;
        }

        public void setExpr(SQLExpr expr) {
            if (expr != null) {
                expr.setParent(this);
            }
            this.expr = expr;
        }

        public SQLCharExpr getComment() {
            return this.comment;
        }

        public void setComment(SQLCharExpr comment) {
            if (comment != null) {
                comment.setParent(this);
            }
            this.comment = comment;
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.expr);
                this.acceptChild(visitor, this.comment);
            }
        }
    }

    public static enum Level {
        CASCADED,
        LOCAL;

    }
}

