/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel;

import com.alibaba.excel.analysis.ExcelAnalyser;
import com.alibaba.excel.analysis.ExcelAnalyserImpl;
import com.alibaba.excel.analysis.ExcelReadExecutor;
import com.alibaba.excel.cache.MapCache;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.parameter.AnalysisParam;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelReader.class);
    private ExcelAnalyser excelAnalyser;

    @Deprecated
    public ExcelReader(InputStream in, ExcelTypeEnum excelTypeEnum, Object customContent, AnalysisEventListener eventListener) {
        this(in, excelTypeEnum, customContent, eventListener, true);
    }

    @Deprecated
    public ExcelReader(InputStream in, Object customContent, AnalysisEventListener eventListener) {
        this(in, customContent, eventListener, true);
    }

    @Deprecated
    public ExcelReader(AnalysisParam param, AnalysisEventListener eventListener) {
        this(param.getIn(), param.getExcelTypeEnum(), param.getCustomContent(), eventListener, true);
    }

    @Deprecated
    public ExcelReader(InputStream in, Object customContent, AnalysisEventListener eventListener, boolean trim) {
        this(in, null, customContent, eventListener, trim);
    }

    @Deprecated
    public ExcelReader(InputStream in, ExcelTypeEnum excelTypeEnum, Object customContent, AnalysisEventListener eventListener, boolean trim) {
        ReadWorkbook readWorkbook = new ReadWorkbook();
        readWorkbook.setInputStream(in);
        readWorkbook.setExcelType(excelTypeEnum);
        readWorkbook.setCustomObject(customContent);
        if (eventListener != null) {
            ArrayList<ReadListener> customReadListenerList = new ArrayList<ReadListener>();
            customReadListenerList.add(eventListener);
            readWorkbook.setCustomReadListenerList(customReadListenerList);
        }
        readWorkbook.setAutoTrim(trim);
        readWorkbook.setAutoCloseStream(Boolean.FALSE);
        readWorkbook.setMandatoryUseInputStream(Boolean.TRUE);
        readWorkbook.setReadCache(new MapCache());
        readWorkbook.setConvertAllFiled(Boolean.FALSE);
        readWorkbook.setDefaultReturnMap(Boolean.FALSE);
        this.excelAnalyser = new ExcelAnalyserImpl(readWorkbook);
    }

    public ExcelReader(ReadWorkbook readWorkbook) {
        this.excelAnalyser = new ExcelAnalyserImpl(readWorkbook);
    }

    @Deprecated
    public void read() {
        this.readAll();
    }

    public void readAll() {
        this.excelAnalyser.analysis(null, Boolean.TRUE);
    }

    public ExcelReader read(ReadSheet ... readSheet) {
        return this.read(Arrays.asList(readSheet));
    }

    public ExcelReader read(List<ReadSheet> readSheetList) {
        this.excelAnalyser.analysis(readSheetList, Boolean.FALSE);
        return this;
    }

    @Deprecated
    public void read(Sheet sheet) {
        ReadSheet readSheet = null;
        if (sheet != null) {
            readSheet = new ReadSheet();
            readSheet.setSheetNo(sheet.getSheetNo() - 1);
            readSheet.setSheetName(sheet.getSheetName());
            readSheet.setClazz(sheet.getClazz());
            readSheet.setHead(sheet.getHead());
            readSheet.setHeadRowNumber(sheet.getHeadLineMun());
        }
        this.read(readSheet);
    }

    @Deprecated
    public void read(Sheet sheet, Class clazz) {
        if (sheet != null) {
            sheet.setClazz(clazz);
        }
        this.read(sheet);
    }

    public AnalysisContext analysisContext() {
        return this.excelAnalyser.analysisContext();
    }

    public ExcelReadExecutor excelExecutor() {
        return this.excelAnalyser.excelExecutor();
    }

    @Deprecated
    public List<Sheet> getSheets() {
        List<ReadSheet> sheetList = this.excelExecutor().sheetList();
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        if (sheetList == null || sheetList.isEmpty()) {
            return sheets;
        }
        for (ReadSheet readSheet : sheetList) {
            Sheet sheet = new Sheet(readSheet.getSheetNo() + 1);
            sheet.setSheetName(readSheet.getSheetName());
            sheets.add(sheet);
        }
        return sheets;
    }

    @Deprecated
    public AnalysisContext getAnalysisContext() {
        return this.analysisContext();
    }

    public void finish() {
        this.excelAnalyser.finish();
    }

    protected void finalize() {
        try {
            this.finish();
        }
        catch (Throwable e) {
            LOGGER.warn("Destroy object failed", e);
        }
    }
}

