/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.logbackadapter;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import com.alibaba.nacos.common.log.NacosLogbackProperties;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.logbackadapter.NacosClientPropertyModel;
import java.util.Collection;

public class NacosClientPropertyModelHandler
extends ModelHandlerBase {
    public NacosClientPropertyModelHandler(Context context) {
        super(context);
    }

    public void handle(ModelInterpretationContext intercon, Model model) throws ModelHandlerException {
        NacosClientPropertyModel propertyModel = (NacosClientPropertyModel)model;
        ActionUtil.Scope scope = ActionUtil.stringToScope((String)propertyModel.getScope());
        String defaultValue = propertyModel.getDefaultValue();
        String source = propertyModel.getSource();
        if (OptionHelper.isNullOrEmpty((String)propertyModel.getName()) || OptionHelper.isNullOrEmpty((String)source)) {
            this.addError("The \"name\" and \"source\" attributes of <nacosClientProperty> must be set");
        }
        ModelUtil.setProperty((ModelInterpretationContext)intercon, (String)propertyModel.getName(), (String)this.getValue(source, defaultValue), (ActionUtil.Scope)scope);
    }

    private String getValue(String source, String defaultValue) {
        Collection logbackClientProperties = NacosServiceLoader.load(NacosLogbackProperties.class);
        return ((NacosLogbackProperties)logbackClientProperties.stream().findFirst().get()).getValue(source, defaultValue);
    }
}

