/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.comment;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.comment.AbstractAliCommentRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.FormalComment;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.jaxen.JaxenException;

public class AbstractMethodOrInterfaceMethodMustUseJavadocRule
extends AbstractAliCommentRule {
    private static final String METHOD_IN_INTERFACE_XPATH = "./ClassOrInterfaceBody/ClassOrInterfaceBodyDeclaration/MethodDeclaration";
    private static final String METHOD_VARIABLE_DECLARATOR_XPATH = "./MethodDeclarator/FormalParameters/FormalParameter/VariableDeclaratorId";
    private static final String MESSAGE_KEY_PREFIX = "java.comment.AbstractMethodOrInterfaceMethodMustUseJavadocRule.violation.msg";
    private static final Pattern EMPTY_CONTENT_PATTERN = Pattern.compile("[/*\\n\\r\\s]+(@.*)?", 32);
    private static final Pattern RETURN_PATTERN = Pattern.compile(".*@return.*", 32);

    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        List methodNodes;
        if (decl.isAbstract()) {
            List methods = decl.findDescendantsOfType(ASTMethodDeclaration.class);
            for (ASTMethodDeclaration method : methods) {
                if (!method.isAbstract()) continue;
                Comment comment = method.comment();
                if (null == comment || !(comment instanceof FormalComment)) {
                    ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)method, data, I18nResources.getMessage("java.comment.AbstractMethodOrInterfaceMethodMustUseJavadocRule.violation.msg.abstract", method.getMethodName()));
                    continue;
                }
                this.checkMethodCommentFormat(method, data);
            }
        }
        if (!decl.isInterface()) {
            return super.visit(decl, data);
        }
        try {
            methodNodes = decl.findChildNodesWithXPath(METHOD_IN_INTERFACE_XPATH);
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression ./ClassOrInterfaceBody/ClassOrInterfaceBodyDeclaration/MethodDeclaration failed: " + e.getLocalizedMessage(), e);
        }
        for (Node node : methodNodes) {
            ASTMethodDeclaration method = (ASTMethodDeclaration)node;
            Comment comment = method.comment();
            if (null == comment || !(comment instanceof FormalComment)) {
                ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)method, data, I18nResources.getMessage("java.comment.AbstractMethodOrInterfaceMethodMustUseJavadocRule.violation.msg.interface", method.getMethodName()));
                continue;
            }
            this.checkMethodCommentFormat(method, data);
        }
        return super.visit(decl, data);
    }

    public void checkMethodCommentFormat(ASTMethodDeclaration method, Object data) {
        ASTNameList nameList;
        List variableDeclaratorIds;
        Comment comment = method.comment();
        String commentContent = comment.getImage();
        if (EMPTY_CONTENT_PATTERN.matcher(commentContent).matches()) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)method, data, I18nResources.getMessage("java.comment.AbstractMethodOrInterfaceMethodMustUseJavadocRule.violation.msg.desc", method.getMethodName()));
        }
        try {
            variableDeclaratorIds = method.findChildNodesWithXPath(METHOD_VARIABLE_DECLARATOR_XPATH);
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression ./MethodDeclarator/FormalParameters/FormalParameter/VariableDeclaratorId failed: " + e.getLocalizedMessage(), e);
        }
        for (Node variableDeclaratorId : variableDeclaratorIds) {
            ASTVariableDeclaratorId param = (ASTVariableDeclaratorId)variableDeclaratorId;
            String paramName = param.getImage();
            Pattern paramNamePattern = Pattern.compile(".*@param\\s+" + paramName + ".*", 32);
            if (paramNamePattern.matcher(commentContent).matches()) continue;
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)method, data, I18nResources.getMessage("java.comment.AbstractMethodOrInterfaceMethodMustUseJavadocRule.violation.msg.parameter", method.getMethodName(), paramName));
        }
        if (!method.isVoid() && !RETURN_PATTERN.matcher(commentContent).matches()) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)method, data, I18nResources.getMessage("java.comment.AbstractMethodOrInterfaceMethodMustUseJavadocRule.violation.msg.return", method.getMethodName()));
        }
        if (null != (nameList = method.getThrows())) {
            List exceptions = nameList.findDescendantsOfType(ASTName.class);
            for (ASTName exception : exceptions) {
                String exceptionName = exception.getImage();
                Pattern exceptionPattern = Pattern.compile(".*@throws\\s+" + exceptionName + ".*", 32);
                if (exceptionPattern.matcher(commentContent).matches()) continue;
                ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)method, data, I18nResources.getMessage("java.comment.AbstractMethodOrInterfaceMethodMustUseJavadocRule.violation.msg.exception", method.getMethodName(), exceptionName));
            }
        }
    }

    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.assignCommentsToDeclarations(cUnit);
        return super.visit(cUnit, data);
    }
}

