/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.concurrent;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.jaxen.JaxenException;

public class ThreadLocalShouldRemoveRule
extends AbstractAliRule {
    private static final String XPATH_TPL = "//StatementExpression/PrimaryExpression/PrimaryPrefix/Name[@Image='%s.remove']";
    private static final String METHOD_INITIAL_VALUE = "initialValue";
    private static final String WITH_INITIAL = "ThreadLocal.withInitial";

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        List fieldDeclarations = node.findDescendantsOfType(ASTFieldDeclaration.class);
        if (fieldDeclarations == null || fieldDeclarations.isEmpty()) {
            return super.visit(node, data);
        }
        for (ASTFieldDeclaration fieldDeclaration : fieldDeclarations) {
            if (fieldDeclaration.getType() != ThreadLocal.class || this.checkThreadLocalWithInitalValue(fieldDeclaration)) continue;
            this.checkThreadLocal(fieldDeclaration, node, data);
        }
        return super.visit(node, data);
    }

    private boolean checkThreadLocalWithInitalValue(ASTFieldDeclaration fieldDeclaration) {
        ASTVariableDeclarator variableDeclarator = (ASTVariableDeclarator)fieldDeclaration.getFirstDescendantOfType(ASTVariableDeclarator.class);
        if (variableDeclarator == null) {
            return false;
        }
        ASTMethodDeclarator initialValueMethod = (ASTMethodDeclarator)variableDeclarator.getFirstDescendantOfType(ASTMethodDeclarator.class);
        if (initialValueMethod != null && METHOD_INITIAL_VALUE.equals(initialValueMethod.getImage())) {
            return true;
        }
        ASTName name = (ASTName)variableDeclarator.getFirstDescendantOfType(ASTName.class);
        return name != null && WITH_INITIAL.equals(name.getImage());
    }

    private void checkThreadLocal(ASTFieldDeclaration fieldDeclaration, ASTCompilationUnit node, Object data) {
        try {
            List nodes = node.findChildNodesWithXPath(String.format(XPATH_TPL, fieldDeclaration.getVariableName()));
            if (nodes == null || nodes.isEmpty()) {
                ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)fieldDeclaration, data, I18nResources.getMessage("java.concurrent.ThreadLocalShouldRemoveRule.violation.msg", fieldDeclaration.getVariableName()));
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
    }
}

