/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.exception;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import com.alibaba.p3c.pmd.lang.java.util.namelist.NameListConfig;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.jaxen.JaxenException;

public class MethodReturnWrapperTypeRule
extends AbstractAliRule {
    private static final Map<String, String> PRIMITIVE_TYPE_TO_WAPPER_TYPE = NameListConfig.NAME_LIST_SERVICE.getNameMap("MethodReturnWrapperTypeRule", "PRIMITIVE_TYPE_TO_WAPPER_TYPE", String.class, String.class);
    private static final String METHOD_RETURN_TYPE_XPATH = "ResultType/Type/PrimitiveType";
    private static final String METHOD_RETURN_OBJECT_XPATH = "Block/BlockStatement/Statement/ReturnStatement/Expression/PrimaryExpression/PrimaryPrefix/Name";
    private static final String METHOD_VARIABLE_TYPE_XPATH = "Type/ReferenceType/ClassOrInterfaceType";
    private static final String METHOD_VARIABLE_NAME_XPATH = "Block/BlockStatement/LocalVariableDeclaration/VariableDeclarator/VariableDeclaratorId";

    public Object visit(ASTMethodDeclaration node, Object data) {
        try {
            List astPrimitiveTypeList = node.findChildNodesWithXPath(METHOD_RETURN_TYPE_XPATH);
            if (astPrimitiveTypeList == null || astPrimitiveTypeList.size() != 1) {
                return super.visit(node, data);
            }
            ASTPrimitiveType astPrimitiveType = (ASTPrimitiveType)astPrimitiveTypeList.get(0);
            if (astPrimitiveType.getType() == null || !astPrimitiveType.getType().isPrimitive()) {
                return super.visit(node, data);
            }
            String primitiveTypeName = astPrimitiveType.getType().getName();
            List nameList = node.findChildNodesWithXPath(METHOD_RETURN_OBJECT_XPATH);
            if (nameList == null || nameList.size() != 1) {
                return super.visit(node, data);
            }
            List methodVariableNameList = node.findChildNodesWithXPath(METHOD_VARIABLE_NAME_XPATH);
            if (methodVariableNameList == null || methodVariableNameList.size() == 0) {
                return super.visit(node, data);
            }
            ASTName astName = (ASTName)nameList.get(0);
            String variableName = astName.getImage();
            for (Node methodVariableNameNode : methodVariableNameList) {
                ASTLocalVariableDeclaration astLocalVariableDeclaration;
                List nodeList;
                ASTVariableDeclaratorId astVariableDeclaratorId = (ASTVariableDeclaratorId)methodVariableNameNode;
                if (!variableName.equals(astVariableDeclaratorId.getImage()) || (nodeList = (astLocalVariableDeclaration = (ASTLocalVariableDeclaration)astVariableDeclaratorId.getFirstParentOfType(ASTLocalVariableDeclaration.class)).findChildNodesWithXPath(METHOD_VARIABLE_TYPE_XPATH)) == null || nodeList.size() != 1) continue;
                ASTClassOrInterfaceType astClassOrInterfaceType = (ASTClassOrInterfaceType)nodeList.get(0);
                if (PRIMITIVE_TYPE_TO_WAPPER_TYPE.get(primitiveTypeName) == null || !PRIMITIVE_TYPE_TO_WAPPER_TYPE.get(primitiveTypeName).equals(astClassOrInterfaceType.getType().getSimpleName())) continue;
                ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.exception.MethodReturnWrapperTypeRule.violation.msg", primitiveTypeName, astClassOrInterfaceType.getType().getSimpleName()));
            }
        }
        catch (JaxenException e) {
            return super.visit(node, data);
        }
        return super.visit(node, data);
    }
}

