/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.other;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.Token;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class MethodTooLongRule
extends AbstractAliRule {
    private static final int MAX_LINE_COUNT = 80;
    private static final String ANNOTATION_PREFIX = "@";

    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTClassOrInterfaceBodyDeclaration classOrInterfaceBodyDecl = (ASTClassOrInterfaceBodyDeclaration)node.jjtGetParent();
        int startLine = classOrInterfaceBodyDecl.getBeginLine();
        int endLine = classOrInterfaceBodyDecl.getEndLine();
        Node firstChild = classOrInterfaceBodyDecl.jjtGetChild(0);
        if (firstChild instanceof ASTAnnotation) {
            Token firstToken = (Token)classOrInterfaceBodyDecl.jjtGetFirstToken();
            if (ANNOTATION_PREFIX.equals(firstToken.image)) {
                ASTAnnotation annotation = (ASTAnnotation)firstChild;
                Token lastToken = (Token)annotation.jjtGetLastToken();
                Token next = lastToken.next;
                startLine = next.beginLine;
            }
        }
        if (endLine - startLine + 1 > 80) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.other.MethodTooLongRule.violation.msg", node.getName()));
        }
        return super.visit(node, data);
    }
}

