/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.RemotingContext;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RemotingUtil;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;

public abstract class AbstractRemotingProcessor<T extends RemotingCommand>
implements RemotingProcessor<T> {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private ExecutorService executor;
    private CommandFactory commandFactory;

    public AbstractRemotingProcessor() {
    }

    public AbstractRemotingProcessor(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public AbstractRemotingProcessor(ExecutorService executor) {
        this.executor = executor;
    }

    public AbstractRemotingProcessor(CommandFactory commandFactory, ExecutorService executor) {
        this.commandFactory = commandFactory;
        this.executor = executor;
    }

    public abstract void doProcess(RemotingContext var1, T var2) throws Exception;

    @Override
    public void process(RemotingContext ctx, T msg, ExecutorService defaultExecutor) throws Exception {
        ProcessTask task = new ProcessTask(this, ctx, msg);
        if (this.getExecutor() != null) {
            this.getExecutor().execute(task);
        } else {
            defaultExecutor.execute(task);
        }
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    static class ProcessTask
    implements Runnable {
        RemotingContext ctx;
        T msg;
        final /* synthetic */ AbstractRemotingProcessor this$0;

        public ProcessTask(RemotingContext ctx, T msg) {
            this.this$0 = var1_1;
            this.ctx = ctx;
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                this.this$0.doProcess(this.ctx, this.msg);
            }
            catch (Throwable e) {
                String remotingAddress = RemotingUtil.parseRemoteAddress(this.ctx.getChannelContext().channel());
                logger.error("Exception caught when process rpc request command in AbstractRemotingProcessor, Id=" + this.msg.getId() + "! Invoke source address is [" + remotingAddress + "].", e);
            }
        }
    }
}

