/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.context;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcParserUtil;
import com.alipay.sofa.rpc.boot.config.FaultToleranceConfigurator;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import com.alipay.sofa.rpc.boot.container.ProviderConfigContainer;
import com.alipay.sofa.rpc.boot.container.RegistryConfigContainer;
import com.alipay.sofa.rpc.boot.container.ServerConfigContainer;
import com.alipay.sofa.rpc.boot.context.event.SofaBootRpcStartEvent;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.event.LookoutSubscriber;
import java.util.Collection;
import org.springframework.context.ApplicationListener;
import org.springframework.util.CollectionUtils;

public class SofaBootRpcStartListener
implements ApplicationListener<SofaBootRpcStartEvent> {
    private final SofaBootRpcProperties sofaBootRpcProperties;
    protected final ProviderConfigContainer providerConfigContainer;
    protected final FaultToleranceConfigurator faultToleranceConfigurator;
    protected final ServerConfigContainer serverConfigContainer;
    protected final RegistryConfigContainer registryConfigContainer;

    public SofaBootRpcStartListener(SofaBootRpcProperties sofaBootRpcProperties, ProviderConfigContainer providerConfigContainer, FaultToleranceConfigurator faultToleranceConfigurator, ServerConfigContainer serverConfigContainer, RegistryConfigContainer registryConfigContainer) {
        this.sofaBootRpcProperties = sofaBootRpcProperties;
        this.providerConfigContainer = providerConfigContainer;
        this.faultToleranceConfigurator = faultToleranceConfigurator;
        this.serverConfigContainer = serverConfigContainer;
        this.registryConfigContainer = registryConfigContainer;
    }

    public void onApplicationEvent(SofaBootRpcStartEvent event) {
        this.disableLookout();
        this.processExtra(event);
        this.faultToleranceConfigurator.startFaultTolerance();
        Collection<ProviderConfig> allProviderConfig = this.providerConfigContainer.getAllProviderConfig();
        if (!CollectionUtils.isEmpty(allProviderConfig)) {
            this.serverConfigContainer.startServers();
        }
        this.providerConfigContainer.setAllowPublish(true);
        this.providerConfigContainer.publishAllProviderConfig();
        this.providerConfigContainer.exportAllDubboProvideConfig();
    }

    protected void processExtra(SofaBootRpcStartEvent event) {
    }

    protected void disableLookout() {
        Boolean disable = SofaBootRpcParserUtil.parseBoolean(this.sofaBootRpcProperties.getLookoutCollectDisable());
        if (disable != null) {
            LookoutSubscriber.setLookoutCollectDisable((boolean)disable);
        }
    }
}

