/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm.async;

import com.aliyun.oss.AsyncHandler;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.comm.DefaultServiceClient;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.async.AsyncPostProcess;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class CallbackImpl<T, RESULT>
implements Callback {
    private RequestMessage requestMessage;
    private ServiceClient.Request request;
    private ClientConfiguration clientConfiguration;
    private ExecutionContext context;
    private ResponseParser<T> parser;
    private boolean keepResponseOpen;
    private Exception exception;
    private AsyncPostProcess postProcess;
    private AsyncHandler<RESULT> asyncHandler;
    private CountDownLatch latch = new CountDownLatch(1);
    private RESULT wrappedResult;

    public RequestMessage getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(RequestMessage requestMessage) {
        this.requestMessage = requestMessage;
    }

    public ServiceClient.Request getRequest() {
        return this.request;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public void setRequest(ServiceClient.Request request) {
        this.request = request;
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    public void setParser(ResponseParser<T> parser) {
        this.parser = parser;
    }

    public void setKeepResponseOpen(boolean keepResponseOpen) {
        this.keepResponseOpen = keepResponseOpen;
    }

    public void setPostProcess(AsyncPostProcess postProcess) {
        this.postProcess = postProcess;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void setAsyncHandler(AsyncHandler<RESULT> asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public RESULT getWrappedResult() {
        return this.wrappedResult;
    }

    public void setWrappedResult(RESULT wrappedResult) {
        this.wrappedResult = wrappedResult;
    }

    private void asyncCallback() {
        try {
            if (this.asyncHandler != null) {
                if (this.exception != null) {
                    this.asyncHandler.onError(this.exception);
                } else {
                    this.asyncHandler.onSuccess(this.wrappedResult);
                }
            }
        }
        catch (Exception ex) {
            LogUtils.logException("[Client]user async call back exception: ", ex, this.requestMessage.getOriginalRequest().isLogEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Call call, IOException e) {
        try {
            this.exception = ExceptionFactory.createNetworkException(e);
            this.asyncCallback();
        }
        finally {
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) {
        ResponseMessage responseMessage = null;
        try {
            responseMessage = DefaultServiceClient.buildResponse(this.request, response);
            this.handleResponse(responseMessage, this.context.getResponseHandlers());
            T parseResult = this.parser.parse(responseMessage);
            this.postProcess.postProcess(parseResult, this);
        }
        catch (ServiceException sex) {
            LogUtils.logException("[Server]Unable to execute HTTP request: ", sex, this.requestMessage.getOriginalRequest().isLogEnabled());
            assert (sex instanceof OSSException);
            this.exception = sex;
        }
        catch (ClientException cex) {
            LogUtils.logException("[Client]Unable to execute HTTP request: ", cex, this.requestMessage.getOriginalRequest().isLogEnabled());
            this.exception = cex;
        }
        catch (ResponseParseException rpe) {
            this.exception = ExceptionFactory.createInvalidResponseException(responseMessage.getRequestId(), rpe.getMessage(), rpe);
            LogUtils.logException("Unable to parse response error: ", rpe);
        }
        catch (Exception ex) {
            LogUtils.logException("[Unknown]Unable to execute HTTP request: ", ex, this.requestMessage.getOriginalRequest().isLogEnabled());
            this.exception = new ClientException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("ConnectionError", ex.getMessage()), ex);
        }
        finally {
            try {
                this.request.close();
                if (responseMessage != null && !this.keepResponseOpen) {
                    OSSUtils.safeCloseResponse(responseMessage);
                }
            }
            catch (IOException iex) {
                LogUtils.logException("Unexpected io exception when trying to close http request: ", iex);
            }
            this.asyncCallback();
            this.latch.countDown();
        }
    }

    private void handleResponse(ResponseMessage response, List<ResponseHandler> responseHandlers) throws ServiceException, ClientException {
        for (ResponseHandler h : responseHandlers) {
            h.handle(response);
        }
    }
}

