/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class ConfigurationProperty<T> {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Function<String, String> REDACT_VALUE_SANITIZER = value -> "redacted";
    private final String name;
    private final List<String> aliases;
    private final String environmentVariable;
    private final String systemProperty;
    private final Function<String, T> converter;
    private final Function<String, String> valueSanitizer;
    private final T defaultValue;
    private final boolean isShared;
    private final boolean isRequired;

    ConfigurationProperty(String name, T defaultValue, boolean isRequired, Function<String, T> converter, boolean isShared, String environmentVariable, String systemProperty, String[] aliases, Function<String, String> valueSanitizer) {
        this.name = Objects.requireNonNull(name, "'name' cannot be null");
        this.converter = Objects.requireNonNull(converter, "'converter' cannot be null");
        this.environmentVariable = environmentVariable;
        this.systemProperty = systemProperty;
        this.aliases = aliases == null ? Collections.emptyList() : Arrays.asList(aliases);
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
        this.isShared = isShared;
        this.valueSanitizer = valueSanitizer == null ? REDACT_VALUE_SANITIZER : valueSanitizer;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public Function<String, String> getValueSanitizer() {
        return this.valueSanitizer;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getName() {
        return this.name;
    }

    public Function<String, T> getConverter() {
        return this.converter;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Iterable<String> getAliases() {
        return this.aliases;
    }

    public String getEnvironmentVariableName() {
        return this.environmentVariable;
    }

    public String getSystemPropertyName() {
        return this.systemProperty;
    }
}

