/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.plus;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.cntaiping.fsc.core.model.Pageable;
import com.cntaiping.fsc.mybatis.plus.TpPlusDao;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.springframework.data.domain.Sort;

public interface BaseDaoPlus<T>
extends BaseMapper<T>,
TpPlusDao {
    public static final Integer MAX_BATCH_SIZE = 1000;

    default public T findById(Serializable paramPK) {
        return (T)this.selectById(paramPK);
    }

    default public List<T> findByIds(Collection<? extends Serializable> paramPKs) {
        return this.selectBatchIds(paramPKs);
    }

    default public void save(T paramT) {
        this.insert(paramT);
    }

    public void saveList(List<T> var1);

    default public void saveInBatches(List<T> paramList, int batchSize) {
        if (batchSize < 1 || batchSize > MAX_BATCH_SIZE) {
            throw new IllegalArgumentException("The batchSize must >= 1 and <= " + MAX_BATCH_SIZE);
        }
        for (List subList : Lists.partition(paramList, (int)batchSize)) {
            this.saveList(subList);
        }
    }

    default public void update(@Param(value="record") T recordParamT, @Param(value="condition") T conditionParamT) {
        this.update(recordParamT, (Wrapper)new UpdateWrapper(conditionParamT));
    }

    default public void updateByMap(@Param(value="record") T recordParamT, @Param(value="condition") Map<String, Object> conditionParamMap) {
        UpdateWrapper wrapper = (UpdateWrapper)Wrappers.update().allEq(conditionParamMap);
        this.update(recordParamT, (Wrapper)wrapper);
    }

    default public void deleteByIds(List<? extends Serializable> paramPKs) {
        this.deleteBatchIds(paramPKs);
    }

    default public List<T> findList(T paramT) {
        return this.selectList((Wrapper)Wrappers.query(paramT));
    }

    default public List<T> findList(T paramT, Sort sort) {
        QueryWrapper wrapper = Wrappers.query(paramT);
        for (Sort.Order order : sort) {
            wrapper = (QueryWrapper)wrapper.orderBy(true, order.isAscending(), (Object)order.getProperty());
        }
        return this.selectList((Wrapper)wrapper);
    }

    default public com.cntaiping.fsc.core.model.Page<T> findList(T paramT, Pageable pageParam) {
        QueryWrapper<T> wrapper = this.toQueryWrapper(Wrappers.query(paramT), pageParam);
        PageDTO tPageDTO = this.transformTo(pageParam);
        tPageDTO = (PageDTO)this.selectPage((IPage)tPageDTO, (Wrapper)wrapper);
        List records = tPageDTO.getRecords();
        Pageable pageable = new Pageable(pageParam.getPageNumber(), pageParam.getPageSize(), true, pageParam.getSort());
        return new com.cntaiping.fsc.core.model.Page(records, pageable, tPageDTO.getTotal());
    }

    default public List<T> findListByMap(Map<String, Object> paramMap) {
        return this.selectByMap(paramMap);
    }

    default public List<T> findListByMap(Map<String, Object> paramMap, Sort sort) {
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().allEq(paramMap);
        if (sort != null) {
            for (Sort.Order order : sort) {
                wrapper = (QueryWrapper)wrapper.orderBy(true, order.isAscending(), (Object)order.getProperty());
            }
        }
        return this.selectList((Wrapper)wrapper);
    }

    default public com.cntaiping.fsc.core.model.Page<T> findListByMap(Map<String, Object> paramMap, Pageable pageParam) {
        QueryWrapper<T> wrapper = this.toQueryWrapper((QueryWrapper)Wrappers.query().allEq(paramMap), pageParam);
        PageDTO tPageDTO = this.transformTo(pageParam);
        tPageDTO = (PageDTO)this.selectPage((IPage)tPageDTO, (Wrapper)wrapper);
        List records = tPageDTO.getRecords();
        Pageable pageable = new Pageable(pageParam.getPageNumber(), pageParam.getPageSize(), true, pageParam.getSort());
        return new com.cntaiping.fsc.core.model.Page(records, pageable, tPageDTO.getTotal());
    }

    default public Long count(T paramT) {
        return this.selectCount((Wrapper)Wrappers.query(paramT));
    }

    default public Long countByMap(Map<String, Object> paramMap) {
        return this.selectCount((Wrapper)Wrappers.query().allEq(paramMap));
    }

    default public PageDTO<T> transformTo(Pageable pageParam) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setOptimizeCountSql(false);
        pageDTO.setOptimizeJoinOfCountSql(false);
        pageDTO.setSearchCount(true);
        pageDTO.setCurrent((long)(pageParam.getPageNumber() + 1));
        pageDTO.setSize((long)pageParam.getPageSize());
        return pageDTO;
    }

    default public <T> QueryWrapper<T> toQueryWrapper(QueryWrapper<T> paramT, Pageable pageParam) {
        QueryWrapper wrapper = paramT;
        Sort sort = pageParam.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                wrapper = (QueryWrapper)wrapper.orderBy(true, order.isAscending(), (Object)order.getProperty());
            }
        }
        return wrapper;
    }

    default public T selectOne(Wrapper<T> queryWrapper) {
        return this.selectOne(queryWrapper, true);
    }

    default public T selectOne(Wrapper<T> queryWrapper, boolean throwEx) {
        Page page = (Page)this.selectPage((IPage)PageDTO.of((long)0L, (long)2L, (boolean)true), queryWrapper);
        List list = page.getRecords();
        int size = list.size();
        if (size == 1) {
            return (T)list.get(0);
        }
        if (size > 1) {
            if (throwEx) {
                throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found :" + page.getTotal());
            }
            return (T)list.get(0);
        }
        return null;
    }
}

