/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.plus.interceptor;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.cntaiping.fsc.mybatis.base.MybatisInterceptorHelper;
import com.cntaiping.fsc.mybatis.base.MybatisStatement;
import com.cntaiping.fsc.mybatis.plus.BaseDaoPlus;
import java.sql.Connection;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=StatementHandler.class, method="getBoundSql", args={}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class TpMybatisPlusInterceptor
extends MybatisPlusInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TpMybatisPlusInterceptor.class);
    private final MybatisInterceptorHelper mybatisInterceptorHelper;

    public TpMybatisPlusInterceptor(MybatisInterceptorHelper mybatisInterceptorHelper) {
        this.mybatisInterceptorHelper = mybatisInterceptorHelper;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        if (!(target instanceof Executor)) {
            return super.intercept(invocation);
        }
        MappedStatement ms = (MappedStatement)args[0];
        String statementId = ms.getId();
        MybatisStatement statement = this.mybatisInterceptorHelper.findMybatisStatement(statementId).orElse(null);
        if (statement == null) {
            return invocation.proceed();
        }
        if (statement.isSubOf(BaseDaoPlus.class)) {
            return super.intercept(invocation);
        }
        return invocation.proceed();
    }
}

