/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.exporter;

import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.monitor.internal.exporter.ApolloClientMetricsExporter;
import com.ctrip.framework.apollo.monitor.internal.listener.ApolloClientMonitorEventListener;
import com.ctrip.framework.apollo.monitor.internal.model.CounterModel;
import com.ctrip.framework.apollo.monitor.internal.model.GaugeModel;
import com.ctrip.framework.apollo.monitor.internal.model.SampleModel;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AbstractApolloClientMetricsExporter
implements ApolloClientMetricsExporter {
    public static final ScheduledExecutorService m_executorService;
    private static final Logger log;
    private static final long INITIAL_DELAY = 5L;
    private static final int THREAD_POOL_SIZE = 1;
    protected List<ApolloClientMonitorEventListener> listeners;

    @Override
    public void init(List<ApolloClientMonitorEventListener> listeners, long collectPeriod) {
        log.info("Initializing metrics exporter with {} listeners and collect period of {} seconds.", (Object)listeners.size(), (Object)collectPeriod);
        this.doInit();
        this.listeners = listeners;
        this.initScheduleMetricsCollectSync(collectPeriod);
        log.info("Metrics collection scheduled with a period of {} seconds.", (Object)collectPeriod);
    }

    protected abstract void doInit();

    private void initScheduleMetricsCollectSync(long collectPeriod) {
        m_executorService.scheduleAtFixedRate(() -> {
            try {
                this.updateMetricsData();
            }
            catch (Throwable ex) {
                log.error("Error updating metrics data", ex);
            }
        }, 5L, collectPeriod, TimeUnit.SECONDS);
    }

    protected void updateMetricsData() {
        log.debug("Start to update metrics data job");
        this.listeners.forEach(listener -> {
            if (listener.isMetricsSampleUpdated()) {
                log.debug("Listener {} has updated samples.", (Object)listener.getName());
                listener.export().forEach(this::registerSample);
            }
        });
    }

    protected void registerSample(SampleModel sample) {
        try {
            switch (sample.getType()) {
                case GAUGE: {
                    GaugeModel gaugeModel = (GaugeModel)sample;
                    this.registerOrUpdateGaugeSample(gaugeModel.getName(), gaugeModel.getTags(), gaugeModel.getValue());
                    break;
                }
                case COUNTER: {
                    CounterModel counterModel = (CounterModel)sample;
                    this.registerOrUpdateCounterSample(counterModel.getName(), counterModel.getTags(), counterModel.getIncreaseValueAndResetZero());
                    break;
                }
                default: {
                    log.warn("Unsupported sample type: {}", (Object)sample.getType());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Register sample error", (Throwable)e);
        }
    }

    static {
        log = DeferredLoggerFactory.getLogger(AbstractApolloClientMetricsExporter.class);
        m_executorService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create((String)ApolloClientMetricsExporter.class.getName(), (boolean)true));
    }
}

