/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.model;

import com.ctrip.framework.apollo.monitor.internal.enums.MetricTypeEnums;
import com.ctrip.framework.apollo.monitor.internal.model.SampleModel;

public class CounterModel
extends SampleModel {
    private CounterModel(String name, double num) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            throw new IllegalArgumentException("Number must be a valid double");
        }
        this.setName(name);
        this.setType(MetricTypeEnums.COUNTER);
        this.value.set(num);
    }

    public static CounterModel create(String name, double value) {
        return new CounterModel(name, value);
    }

    public void increase(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Value must be a valid double");
        }
        this.value.addAndGet(value);
    }

    public double getIncreaseValueAndResetZero() {
        return this.value.getAndSet(0.0);
    }
}

