/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo;

import com.github.fakemongo.FongoConnectionSource;
import com.mongodb.DB;
import com.mongodb.FongoDB;
import com.mongodb.MockMongoClient;
import com.mongodb.MongoClient;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ServerVersion;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.WriteOperation;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fongo
implements OperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(Fongo.class);
    public static final ServerVersion V3_2_SERVER_VERSION = new ServerVersion(3, 2);
    public static final ServerVersion V3_3_SERVER_VERSION = new ServerVersion(3, 3);
    public static final ServerVersion V3_SERVER_VERSION = new ServerVersion(3, 0);
    public static final ServerVersion OLD_SERVER_VERSION = new ServerVersion(0, 0);
    public static final ServerVersion DEFAULT_SERVER_VERSION = V3_2_SERVER_VERSION;
    private final Map<String, FongoDB> dbMap = new ConcurrentHashMap<String, FongoDB>();
    private final ServerAddress serverAddress;
    private final MongoClient mongo;
    private final String name;
    private final ServerVersion serverVersion;

    public Fongo(String name) {
        this(name, DEFAULT_SERVER_VERSION);
    }

    public Fongo(String name, ServerVersion serverVersion) {
        this.name = name;
        this.serverAddress = new ServerAddress(new InetSocketAddress(ServerAddress.defaultHost(), ServerAddress.defaultPort()));
        this.serverVersion = serverVersion;
        this.mongo = this.createMongo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FongoDB getDB(String dbname) {
        Map<String, FongoDB> map = this.dbMap;
        synchronized (map) {
            FongoDB fongoDb = this.dbMap.get(dbname);
            if (fongoDb == null) {
                fongoDb = new FongoDB(this, dbname);
                this.dbMap.put(dbname, fongoDb);
            }
            return fongoDb;
        }
    }

    public synchronized MongoDatabase getDatabase(String databaseName) {
        return this.mongo.getDatabase(databaseName);
    }

    public Collection<DB> getUsedDatabases() {
        return new ArrayList<DB>(this.dbMap.values());
    }

    public List<String> getDatabaseNames() {
        return new ArrayList<String>(this.dbMap.keySet());
    }

    public void dropDatabase(String dbName) {
        FongoDB db = this.dbMap.remove(dbName);
        if (db != null) {
            db.dropDatabase();
        }
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public WriteConcern getWriteConcern() {
        return this.mongo.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.mongo.getReadConcern();
    }

    private MongoClient createMongo() {
        return MockMongoClient.create(this);
    }

    public <T> T execute(ReadOperation<T> operation, final ReadPreference readPreference) {
        return (T)operation.execute(new ReadBinding(){

            public ReadPreference getReadPreference() {
                return readPreference;
            }

            public ConnectionSource getReadConnectionSource() {
                return new FongoConnectionSource(Fongo.this);
            }

            public ReadBinding retain() {
                return this;
            }

            public int getCount() {
                return 0;
            }

            public void release() {
            }
        });
    }

    public <T> T execute(WriteOperation<T> operation) {
        return (T)operation.execute(new WriteBinding(){

            public ConnectionSource getWriteConnectionSource() {
                return new FongoConnectionSource(Fongo.this);
            }

            public WriteBinding retain() {
                return this;
            }

            public int getCount() {
                return 0;
            }

            public void release() {
            }
        });
    }

    public String toString() {
        return "Fongo (" + this.name + ")";
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }
}

