/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarlakxen.embedphantomjs.executor;

import com.github.jarlakxen.embedphantomjs.PhantomJSReference;
import com.github.jarlakxen.embedphantomjs.exception.UnexpectedProcessEndException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PhantomJSConsoleExecutor {
    private static final Logger LOGGER = Logger.getLogger(PhantomJSConsoleExecutor.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;
    private static final char[] SYSTEM_NEWLINE = System.getProperty("line.separator").toCharArray();
    private static final String DEFAULT_PHANTOMJS_CONSOLE_PREFIX = "phantomjs> ";
    private static final List<String> DEFAULT_PHANTOMJS_CONSOLE_POSTFIXS = Arrays.asList("{}", "undefined");
    private static final String PHANTOMJS_PARSER_ERROR_PREFIX = "Parse error";
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final PhantomJSReference phantomReference;
    private final File scriptFile;
    private final String[] scriptArgs;
    private final String consolePrefix;
    private final List<String> consolePostfix;
    private Process process;

    public PhantomJSConsoleExecutor(PhantomJSReference phantomReference) {
        this(phantomReference, null, new String[0]);
    }

    public PhantomJSConsoleExecutor(PhantomJSReference phantomReference, File scriptFile, String ... scriptArgs) {
        this(phantomReference, DEFAULT_PHANTOMJS_CONSOLE_PREFIX, DEFAULT_PHANTOMJS_CONSOLE_POSTFIXS, scriptFile, scriptArgs);
    }

    public PhantomJSConsoleExecutor(PhantomJSReference phantomReference, String consolePrefix, List<String> consolePostfix, File scriptFile, String ... scriptArgs) {
        this.phantomReference = phantomReference;
        this.scriptFile = scriptFile;
        this.scriptArgs = scriptArgs;
        this.consolePrefix = consolePrefix;
        this.consolePostfix = consolePostfix;
    }

    public int getPid() {
        if (this.process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = this.process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getInt(this.process);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean isAlive() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
    }

    public void start() {
        try {
            String cmd = this.phantomReference.getBinaryPath();
            if (this.scriptFile != null) {
                cmd = cmd + " " + this.scriptFile.getAbsolutePath();
            }
            if (this.scriptArgs != null && this.scriptArgs.length > 0) {
                cmd = cmd + " " + StringUtils.join((Object[])this.scriptArgs, (String)" ");
            }
            this.process = Runtime.getRuntime().exec(cmd);
            if (StringUtils.isNotBlank((CharSequence)this.consolePrefix)) {
                this.process.getInputStream().read(new byte[this.consolePrefix.length()]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int destroy() {
        try {
            this.process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isAlive()) {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.process.exitValue();
    }

    public CompletableFuture<String> execute(String scriptSource) {
        return this.execute(IOUtils.toInputStream((String)scriptSource, (Charset)Charset.defaultCharset()), this.consolePostfix);
    }

    public CompletableFuture<String> execute(String scriptSource, String ... endLines) {
        return this.execute(IOUtils.toInputStream((String)scriptSource, (Charset)Charset.defaultCharset()), Arrays.asList(endLines));
    }

    public CompletableFuture<String> execute(InputStream scriptSourceInputStream, String ... endLines) {
        return this.execute(scriptSourceInputStream, Arrays.asList(endLines));
    }

    public CompletableFuture<String> execute(InputStream scriptSourceInputStream, List<String> endLines) throws UnexpectedProcessEndException {
        return CompletableFuture.supplyAsync(() -> this.doExecute(scriptSourceInputStream, endLines), this.executorService);
    }

    private String doExecute(InputStream scriptSourceInputStream, List<String> endLines) {
        if (!this.isAlive()) {
            throw new UnexpectedProcessEndException();
        }
        try {
            String input = this.copy(scriptSourceInputStream, this.process.getOutputStream());
            if (!this.endWithNewLine(input)) {
                for (char c : SYSTEM_NEWLINE) {
                    this.process.getOutputStream().write(c);
                }
            }
            this.process.getOutputStream().flush();
            String output = this.readPhantomJSOutput(this.process.getInputStream(), endLines);
            LOGGER.debug((Object)("Program output: " + output));
            return output;
        }
        catch (IOException e) {
            throw new UnexpectedProcessEndException(e);
        }
    }

    private String readPhantomJSOutput(InputStream processInput, List<String> endLines) throws IOException {
        StringBuilder out = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(processInput, "UTF-8"));
        while (true) {
            String line = in.readLine();
            LOGGER.trace((Object)("Incoming line from process: " + line));
            if (line.equals(PHANTOMJS_PARSER_ERROR_PREFIX)) {
                return line;
            }
            if (line == null || endLines.contains(line)) {
                if (!StringUtils.isNotBlank((CharSequence)this.consolePrefix)) break;
                in.skip(this.consolePrefix.length());
                break;
            }
            if (out.length() > 0) {
                out.append("\n");
            }
            out.append(line);
        }
        return out.toString();
    }

    private boolean endWithNewLine(String input) {
        return input.endsWith(String.valueOf(SYSTEM_NEWLINE));
    }

    private String copy(InputStream input, OutputStream output) throws IOException {
        StringBuilder inputString = new StringBuilder();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            inputString.append(new String(buffer, 0, n));
        }
        return inputString.toString();
    }

    public String getConsolePrefix() {
        return this.consolePrefix;
    }

    public List<String> getConsolePostfix() {
        return this.consolePostfix;
    }
}

