/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarlakxen.embedphantomjs.executor;

import com.github.jarlakxen.embedphantomjs.ExecutionTimeout;
import com.github.jarlakxen.embedphantomjs.PhantomJSReference;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PhantomJSFileExecutor {
    private static final Logger LOGGER = Logger.getLogger(PhantomJSFileExecutor.class);
    private final ExecutorService processExecutorService;
    private final PhantomJSReference phantomReference;
    private final ExecutionTimeout executionTimeout;

    public PhantomJSFileExecutor(PhantomJSReference phantomReference, ExecutionTimeout executionTimeout) {
        this(phantomReference, Executors.newCachedThreadPool(), executionTimeout);
    }

    public PhantomJSFileExecutor(PhantomJSReference phantomReference, ExecutorService executorService, ExecutionTimeout executionTimeout) {
        this.phantomReference = phantomReference;
        this.executionTimeout = executionTimeout;
        this.processExecutorService = executorService;
    }

    public CompletableFuture<String> execute(String fileContent, String ... args) {
        try {
            File tmp = File.createTempFile(RandomStringUtils.randomAlphabetic((int)10), ".js");
            FileUtils.write((File)tmp, (CharSequence)fileContent, (Charset)Charset.defaultCharset());
            CompletableFuture<String> result = this.execute(tmp, args);
            return ((CompletableFuture)result.handle((value, error) -> {
                if (tmp != null) {
                    tmp.delete();
                }
                if (error == null) {
                    return CompletableFuture.completedFuture(value);
                }
                LOGGER.error((Object)"", error);
                CompletableFuture errorFuture = new CompletableFuture();
                errorFuture.completeExceptionally((Throwable)error);
                return errorFuture;
            })).thenCompose(Function.identity());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<String> execute(File sourceFile, String ... args) {
        String cmd = this.phantomReference.getBinaryPath() + " " + this.phantomReference.getCommandLineOptions() + " " + sourceFile.getAbsolutePath() + " " + StringUtils.join((Object[])args, (String)" ");
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            LOGGER.info((Object)("Command to execute: " + cmd));
            CompletableFuture<String> action = CompletableFuture.supplyAsync(() -> {
                try {
                    LOGGER.info((Object)("Command to execute: " + cmd));
                    String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
                    process.waitFor();
                    LOGGER.debug((Object)("Command " + cmd + " output:" + output));
                    return output;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, this.processExecutorService);
            CompletableFuture.runAsync(() -> {
                try {
                    action.get(this.executionTimeout.getTimeout(), this.executionTimeout.getUnit());
                }
                catch (Exception ex) {
                    action.completeExceptionally(ex);
                    process.destroy();
                }
            });
            return action;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

