/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.condition;

import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class OnMissingBeanCondition
extends SpringBootCondition
implements ConfigurationCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map beanAttributes = metadata.getAnnotationAttributes(Bean.class.getName());
        String beanName = ((String[])beanAttributes.get("name"))[0];
        if (StringUtils.isEmpty((Object)beanName)) {
            throw new IllegalStateException("OnMissingBeanCondition can't detect bean name!");
        }
        boolean missingBean = !context.getBeanFactory().containsBean(context.getEnvironment().resolveRequiredPlaceholders(beanName));
        return missingBean ? ConditionOutcome.match((String)(beanName + " not found")) : ConditionOutcome.noMatch((String)(beanName + " found"));
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }
}

