/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser;

import com.cognos.org.apache.axis.encoding.Base64;
import com.cognos.org.apache.axis.encoding.ser.SimpleDeserializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;

public class Base64Deserializer
extends SimpleDeserializer {
    public Base64Deserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public Object getValue() {
        Object returnValue;
        block11: {
            returnValue = super.getValue();
            if (this.value instanceof AttachmentPart) {
                AttachmentPart part = (AttachmentPart)this.value;
                try {
                    Object content = part.getContent();
                    if (content instanceof String) {
                        String returnValueString = (String)part.getContent();
                        returnValue = returnValueString.getBytes();
                        break block11;
                    }
                    if (content instanceof InputStream) {
                        ByteArrayOutputStream bos;
                        block13: {
                            InputStream is;
                            block12: {
                                is = (InputStream)content;
                                bos = new ByteArrayOutputStream();
                                byte[] buf = new byte[1024];
                                int iread = 0;
                                try {
                                    while ((iread = is.read(buf)) > -1) {
                                        bos.write(buf, 0, iread);
                                    }
                                    bos.flush();
                                    bos.close();
                                }
                                catch (IOException e1) {
                                    if (!log.isErrorEnabled()) break block12;
                                    log.error((Object)"Base64Deserializer.getValue() IOException reading bytearrayoutputstream.");
                                }
                            }
                            try {
                                is.close();
                            }
                            catch (IOException e1) {
                                if (!log.isErrorEnabled()) break block13;
                                log.error((Object)"Base64Deserializer.getValue() IOException closing inputstream.");
                            }
                        }
                        returnValue = bos.toByteArray();
                        break block11;
                    }
                    String type = content == null ? "null" : content.getClass().getName();
                    String msg = "Base64Deserializer.getValue() expected content of type String or InputStream but was: " + type;
                    if (log.isErrorEnabled()) {
                        log.error((Object)msg);
                    }
                }
                catch (SOAPException e) {
                    if (!log.isErrorEnabled()) break block11;
                    log.error((Object)("Base64Deserializer.getValue() SOAPException " + e.getLocalizedMessage()));
                }
            }
        }
        return returnValue;
    }

    public Object makeValue(String source) throws Exception {
        byte[] value = Base64.decode(source);
        if (value == null) {
            if (this.javaType == Byte[].class) {
                return new Byte[0];
            }
            return new byte[0];
        }
        if (this.javaType == Byte[].class) {
            Byte[] data = new Byte[value.length];
            for (int i = 0; i < data.length; ++i) {
                byte b = value[i];
                data[i] = new Byte(b);
            }
            return data;
        }
        return value;
    }
}

