/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser.castor;

import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.encoding.SerializationContext;
import com.cognos.org.apache.axis.encoding.Serializer;
import com.cognos.org.apache.axis.encoding.ser.castor.AxisContentHandler;
import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.wsdl.fromJava.Types;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class CastorSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(CastorSerializer.class.getName());

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        try {
            AxisContentHandler hand = new AxisContentHandler(context);
            Marshaller marshaller = new Marshaller((ContentHandler)hand);
            marshaller.setMarshalAsDocument(false);
            String localPart = name.getLocalPart();
            int arrayDims = localPart.indexOf(91);
            if (arrayDims != -1) {
                localPart = localPart.substring(0, arrayDims);
            }
            marshaller.setRootElement(localPart);
            marshaller.marshal(value);
        }
        catch (MarshalException me) {
            log.error((Object)Messages.getMessage("castorMarshalException00"), (Throwable)me);
            throw new IOException(Messages.getMessage("castorMarshalException00") + me.getLocalizedMessage());
        }
        catch (ValidationException ve) {
            log.error((Object)Messages.getMessage("castorValidationException00"), (Throwable)ve);
            throw new IOException(Messages.getMessage("castorValidationException00") + ve.getLocation() + ": " + ve.getLocalizedMessage());
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}

