/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.management;

import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.i18n.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class Registrar {
    protected static Log log = LogFactory.getLog(Registrar.class.getName());
    private static ModelerBinding modelerBinding = null;

    public static boolean register(Object objectToRegister, String name, String context) {
        if (Registrar.isBound()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering " + objectToRegister + " as " + name));
            }
            return modelerBinding.register(objectToRegister, name, context);
        }
        return false;
    }

    public static boolean isBound() {
        Registrar.createModelerBinding();
        return modelerBinding.canBind();
    }

    private static void createModelerBinding() {
        if (modelerBinding == null) {
            modelerBinding = new ModelerBinding();
        }
    }

    static class ModelerBinding {
        protected static Log log = LogFactory.getLog(ModelerBinding.class.getName());
        Object registry;
        Method registerComponent;

        public ModelerBinding() {
            this.bindToModeler();
        }

        public boolean canBind() {
            return this.registry != null;
        }

        public boolean register(Object objectToRegister, String name, String context) {
            if (this.registry != null) {
                Object[] args = new Object[]{objectToRegister, name, context};
                try {
                    this.registerComponent.invoke(this.registry, args);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Registered " + name + " in " + context));
                    }
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e);
                    return false;
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)e);
                    return false;
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e);
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean bindToModeler() {
            Class<?> clazz;
            Exception ex = null;
            try {
                clazz = Class.forName("org.apache.commons.modeler.Registry");
            }
            catch (ClassNotFoundException e) {
                this.registry = null;
                return false;
            }
            try {
                Class[] getRegistryArgs = new Class[]{Object.class, Object.class};
                Method getRegistry = clazz.getMethod("getRegistry", getRegistryArgs);
                Object[] getRegistryOptions = new Object[]{null, null};
                this.registry = getRegistry.invoke(null, getRegistryOptions);
                Class[] registerArgs = new Class[]{Object.class, String.class, String.class};
                this.registerComponent = clazz.getMethod("registerComponent", registerArgs);
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            catch (NoSuchMethodException e) {
                ex = e;
            }
            if (ex != null) {
                log.warn((Object)Messages.getMessage("Registrar.cantregister"), (Throwable)ex);
                this.registry = null;
                return false;
            }
            return true;
        }
    }
}

