/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.wsdl.toJava;

import com.cognos.org.apache.axis.wsdl.symbolTable.BindingEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.Parameters;
import com.cognos.org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable;
import com.cognos.org.apache.axis.wsdl.toJava.Emitter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaBindingWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.wsdl.Operation;
import javax.wsdl.PortType;

public class JavaInterfaceWriter
extends JavaClassWriter {
    protected PortType portType;
    protected BindingEntry bEntry;

    protected JavaInterfaceWriter(Emitter emitter, PortTypeEntry ptEntry, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, (String)bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME), "interface");
        this.portType = ptEntry.getPortType();
        this.bEntry = bEntry;
    }

    public void generate() throws IOException {
        String fqClass = this.getPackage() + "." + this.getClassName();
        if (!this.emitter.getGeneratedFileInfo().getClassNames().contains(fqClass)) {
            super.generate();
        }
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getExtendsText() {
        return "extends java.rmi.Remote ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        for (Operation operation : this.portType.getOperations()) {
            this.writeOperation(pw, operation);
        }
    }

    protected void writeOperation(PrintWriter pw, Operation operation) throws IOException {
        this.writeComment(pw, operation.getDocumentationElement(), true);
        Parameters parms = this.bEntry.getParameters(operation);
        pw.println(parms.signature + ";");
    }
}

