/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.AddShutDownHookAction;
import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.ModDetectTimerTask;
import com.ibm.db2.cmx.runtime.internal.NewShutdownTimerServicesThreadAction;
import com.ibm.db2.cmx.runtime.internal.NewTimerAction;
import com.ibm.db2.cmx.runtime.internal.PdqServiceThreadProvider;
import com.ibm.db2.cmx.runtime.internal.ReloadKeyProcessor;
import com.ibm.db2.cmx.runtime.internal.ReloadThreadFactory;
import com.ibm.db2.cmx.runtime.internal.ShutdownTimerServicesThread;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.repository.sql.MetadataGroupDataActiveRefresh;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.generic.GenericConnectionExecutionHandler;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PdqTimerServices {
    protected static final long minutesToMilliseconds = 60000L;
    protected static Timer timerService_ = null;
    private static ModDetectTimerTask modDectTimer_ = null;
    private static ShutdownTimerServicesThread stst_ = null;
    private static long modificationDetectionTimerValue_ = 0L;
    private static long modificationDetectionTimerValueInMillis_ = 0L;
    private static long lastRepositoryActivationTimerValueInMillis_ = 0L;
    protected static Map<CentralStoreKey, LinkedList<WeakReference<CentralStoreKey>>> modificationDetectionQueue_ = new ConcurrentHashMap<CentralStoreKey, LinkedList<WeakReference<CentralStoreKey>>>(100);
    private static final LinkedBlockingQueue<Runnable> loadOfNewPropertiesAndXmlQueue = new LinkedBlockingQueue();
    protected static ThreadPoolExecutor loadOfNewPropertiesAndXmlThreadPool = null;
    private static Logger logger__ = Log.getClientOptimizerLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void restartTimer(boolean bl2, long l8) {
        if (l8 != 0L) {
            long l9 = Long.MAX_VALUE;
            boolean bl3 = false;
            Map<CentralStoreKey, LinkedList<WeakReference<CentralStoreKey>>> map = modificationDetectionQueue_;
            synchronized (map) {
                if (l8 != -1L && (modificationDetectionTimerValue_ == 0L || modificationDetectionTimerValue_ > l8)) {
                    l9 = PdqTimerServices.cancelModDetectTimer();
                    modificationDetectionTimerValue_ = l8;
                }
                if (modificationDetectionQueue_.isEmpty()) {
                    PdqTimerServices.cancelModDetectTimer();
                } else if (modDectTimer_ == null && modificationDetectionTimerValue_ != 0L) {
                    modDectTimer_ = new ModDetectTimerTask();
                    modificationDetectionTimerValueInMillis_ = modificationDetectionTimerValue_ * 60000L;
                    l9 = l9 > modificationDetectionTimerValueInMillis_ ? modificationDetectionTimerValueInMillis_ : l9;
                    l9 = l9 <= 0L ? 1L : l9;
                    bl3 = true;
                }
            }
            if (bl3) {
                timerService_.schedule((TimerTask)modDectTimer_, l9, modificationDetectionTimerValueInMillis_);
            }
        }
    }

    private static long cancelModDetectTimer() {
        if (modDectTimer_ != null) {
            modDectTimer_.cancel();
            modDectTimer_ = null;
            if (!modificationDetectionQueue_.isEmpty()) {
                return PdqTimerServices.processModificationCheckQueue();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initTimerServices() {
        if (timerService_ == null) {
            Map<CentralStoreKey, LinkedList<WeakReference<CentralStoreKey>>> map = modificationDetectionQueue_;
            synchronized (map) {
                if (timerService_ == null) {
                    timerService_ = AccessController.doPrivileged(new NewTimerAction(true));
                    PdqTimerServices.restartTimer(true, -1L);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initShutdownServices() {
        if (stst_ == null) {
            Map<CentralStoreKey, LinkedList<WeakReference<CentralStoreKey>>> map = modificationDetectionQueue_;
            synchronized (map) {
                stst_ = (ShutdownTimerServicesThread)AccessController.doPrivileged(new NewShutdownTimerServicesThreadAction());
                try {
                    AccessController.doPrivileged(new AddShutDownHookAction(stst_));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToModificationDetectionQueue(CentralStoreKey centralStoreKey, long l8) {
        long l9;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, centralStoreKey, "addToModificationDetectionQueue", "PropertyRefreshInterval: " + l8);
        }
        centralStoreKey.getPropertiesLastModifiedTime();
        Map<CentralStoreKey, LinkedList<WeakReference<CentralStoreKey>>> map = modificationDetectionQueue_;
        synchronized (map) {
            if (loadOfNewPropertiesAndXmlThreadPool == null) {
                loadOfNewPropertiesAndXmlThreadPool = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, loadOfNewPropertiesAndXmlQueue, new ReloadThreadFactory());
            }
            centralStoreKey.setPropertiesRefreshIntervalInMinutes(l8);
            centralStoreKey.setLastCheckedTime(System.currentTimeMillis());
            WeakReference<CentralStoreKey> weakReference = new WeakReference<CentralStoreKey>(centralStoreKey);
            CentralStoreKey centralStoreKey2 = centralStoreKey.cloneKey();
            centralStoreKey2.setDeepCompare(false);
            LinkedList<WeakReference<CentralStoreKey>> linkedList = modificationDetectionQueue_.get(centralStoreKey2);
            if (linkedList != null) {
                linkedList.add(weakReference);
            } else {
                linkedList = new LinkedList();
                linkedList.add(weakReference);
                modificationDetectionQueue_.put(centralStoreKey2, linkedList);
            }
        }
        long l10 = l8;
        if (centralStoreKey.getCompareToRV_2_2_7() >= 0 && (l9 = Long.parseLong(DataProperties.getProperty("pdq.runtimeGroupActivationCheckInterval"))) > 0L && l8 >= 0L && (l8 > l9 || l8 == 0L)) {
            l10 = l9;
        }
        PdqTimerServices.restartTimer(false, l10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long processModificationCheckQueue() {
        long l8 = System.currentTimeMillis();
        boolean bl2 = false;
        long l9 = l8 + (modificationDetectionTimerValueInMillis_ >> 1);
        long l10 = modificationDetectionTimerValueInMillis_;
        CentralStoreKey centralStoreKey = null;
        CentralStoreKey centralStoreKey2 = null;
        HashMap<CentralStoreKey, MetadataGroupDataActiveRefresh[]> hashMap = new HashMap<CentralStoreKey, MetadataGroupDataActiveRefresh[]>(10);
        long l11 = 0L;
        String string = DataProperties.getProperty("pdq.runtimeGroupActivationCheckInterval");
        if (string != null && string.length() > 0) {
            l11 = Long.parseLong(string);
        }
        Map<CentralStoreKey, LinkedList<WeakReference<CentralStoreKey>>> map = modificationDetectionQueue_;
        synchronized (map) {
            Iterator<CentralStoreKey> iterator = modificationDetectionQueue_.keySet().iterator();
            while (iterator.hasNext()) {
                CentralStoreKey centralStoreKey3;
                CentralStoreKey centralStoreKey4;
                CentralStoreKey centralStoreKey5 = iterator.next();
                boolean bl3 = false;
                LinkedList<WeakReference<CentralStoreKey>> linkedList = modificationDetectionQueue_.get(centralStoreKey5);
                Iterator iterator2 = linkedList.iterator();
                if (centralStoreKey5.getCompareToRV_2_2_7() >= 0 && l11 > 0L && lastRepositoryActivationTimerValueInMillis_ + l11 * 60000L <= l8) {
                    centralStoreKey4 = null;
                    while (iterator2.hasNext() && centralStoreKey4 == null) {
                        centralStoreKey4 = (CentralStoreKey)((WeakReference)iterator2.next()).get();
                        if (centralStoreKey4 != null) continue;
                        iterator2.remove();
                    }
                    if (centralStoreKey4 != null) {
                        int n2;
                        centralStoreKey3 = centralStoreKey5.cloneKey();
                        centralStoreKey3.setCompareForSameDBMSRepository(true);
                        MetadataGroupDataActiveRefresh[] metadataGroupDataActiveRefreshArray = (MetadataGroupDataActiveRefresh[])hashMap.get(centralStoreKey3);
                        if (metadataGroupDataActiveRefreshArray == null) {
                            MetadataGroupDataActiveRefresh metadataGroupDataActiveRefresh;
                            metadataGroupDataActiveRefreshArray = centralStoreKey3.getMetadataGroupDataActiveRefresh();
                            if (metadataGroupDataActiveRefreshArray.length > 0 && logger__.isLoggable(Level.FINER)) {
                                String string2 = "";
                                for (n2 = 0; n2 < metadataGroupDataActiveRefreshArray.length; ++n2) {
                                    if (n2 > 0) {
                                        string2 = string2 + ", ";
                                    }
                                    metadataGroupDataActiveRefresh = metadataGroupDataActiveRefreshArray[n2];
                                    string2 = string2 + metadataGroupDataActiveRefresh.getName() + "." + metadataGroupDataActiveRefresh.getVersion();
                                }
                                DataLogger.logAtLevelFiner(logger__, centralStoreKey5, "processModificationCheckQueue", "[systemTime:" + l8 + "]NEW getMetadataGroupDataActiveRefresh: Activated Groups (" + string2 + ")");
                            }
                            int n3 = 0;
                            for (n2 = 0; n2 < metadataGroupDataActiveRefreshArray.length; ++n2) {
                                metadataGroupDataActiveRefresh = metadataGroupDataActiveRefreshArray[n2];
                                if (metadataGroupDataActiveRefresh.getAsync_refresh_track() == null || metadataGroupDataActiveRefresh.getAsync_refresh_track() <= n3) continue;
                                n3 = metadataGroupDataActiveRefresh.getAsync_refresh_track();
                            }
                            if (n3 > 0) {
                                centralStoreKey3.setRepositoryAsyncRefreshTrack(n3);
                            }
                            hashMap.put(centralStoreKey3, metadataGroupDataActiveRefreshArray);
                        } else if (metadataGroupDataActiveRefreshArray.length > 0 && logger__.isLoggable(Level.FINER)) {
                            String string3 = "";
                            for (n2 = 0; n2 < metadataGroupDataActiveRefreshArray.length; ++n2) {
                                if (n2 > 0) {
                                    string3 = string3 + ", ";
                                }
                                MetadataGroupDataActiveRefresh metadataGroupDataActiveRefresh = metadataGroupDataActiveRefreshArray[n2];
                                string3 = string3 + metadataGroupDataActiveRefresh.getName() + "." + metadataGroupDataActiveRefresh.getVersion();
                            }
                            DataLogger.logAtLevelFiner(logger__, centralStoreKey5, "processModificationCheckQueue", "[systemTime:" + l8 + "]CACHED getMetadataGroupDataActiveRefresh: Activated Groups (" + string3 + ")");
                        }
                        if (metadataGroupDataActiveRefreshArray.length > 0) {
                            int n4 = centralStoreKey3.getRepositoryAsyncRefreshTrack();
                            if (n4 > 0) {
                                centralStoreKey5.setRepositoryAsyncRefreshTrack(n4);
                            }
                            for (n2 = 0; !bl3 && n2 < metadataGroupDataActiveRefreshArray.length; ++n2) {
                                if (!metadataGroupDataActiveRefreshArray[n2].getName().equals(centralStoreKey3.getPropertiesGroupId())) continue;
                                bl3 = true;
                            }
                        }
                    }
                    bl2 = true;
                }
                iterator2 = linkedList.iterator();
                centralStoreKey4 = null;
                while (iterator2.hasNext()) {
                    centralStoreKey4 = (CentralStoreKey)((WeakReference)iterator2.next()).get();
                    if (centralStoreKey4 == null) {
                        iterator2.remove();
                        continue;
                    }
                    if (bl3) {
                        if (centralStoreKey == null) {
                            centralStoreKey = centralStoreKey4.cloneKey();
                            centralStoreKey.resetExistanceCheckedFlags();
                        }
                        if ((centralStoreKey3 = centralStoreKey4.getXmlKey()) == null) {
                            centralStoreKey3 = centralStoreKey4;
                            centralStoreKey2 = centralStoreKey;
                            break;
                        }
                        centralStoreKey2 = centralStoreKey3.cloneKey();
                        centralStoreKey2.resetExistanceCheckedFlags();
                        break;
                    }
                    long l12 = centralStoreKey4.getPropertiesRefreshIntervalInMillis();
                    if (l12 <= 0L) continue;
                    long l13 = centralStoreKey4.getLastCheckedTime() + l12;
                    if (l9 > l13) {
                        CentralStoreKey centralStoreKey6;
                        if (centralStoreKey == null) {
                            centralStoreKey = centralStoreKey4.cloneKey();
                            centralStoreKey.resetExistanceCheckedFlags();
                        }
                        if ((centralStoreKey6 = centralStoreKey4.getXmlKey()) == null) {
                            centralStoreKey6 = centralStoreKey4;
                            centralStoreKey2 = centralStoreKey;
                        } else {
                            centralStoreKey2 = centralStoreKey6.cloneKey();
                            centralStoreKey2.resetExistanceCheckedFlags();
                        }
                        long l14 = centralStoreKey4.getPropertiesLastModifiedTime();
                        long l15 = centralStoreKey6.getInputXmlLastModifiedTime();
                        if (l14 != centralStoreKey.getPropertiesLastModifiedTime() || l15 != centralStoreKey2.getInputXmlLastModifiedTime()) {
                            bl3 = true;
                            break;
                        }
                        centralStoreKey4.setLastCheckedTime(l8);
                        continue;
                    }
                    long l16 = l13 - l8;
                    l10 = l16 < l10 ? l16 : l10;
                }
                if (bl3) {
                    ArrayList<WeakReference<CentralStoreKey>> arrayList = new ArrayList<WeakReference<CentralStoreKey>>(linkedList);
                    linkedList.clear();
                    try {
                        loadOfNewPropertiesAndXmlThreadPool.execute(new ReloadKeyProcessor(arrayList, centralStoreKey, centralStoreKey2));
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                } else if (linkedList.isEmpty()) {
                    iterator.remove();
                } else if (centralStoreKey5.getCompareToRV_2_2_7() >= 0 && l11 > 0L) {
                    long l17 = l11 * 60000L;
                    if (l10 > 0L) {
                        if (l17 < l10) {
                            l10 = l17;
                        }
                    } else {
                        l10 = l17;
                    }
                }
                centralStoreKey = null;
            }
            if (bl2) {
                lastRepositoryActivationTimerValueInMillis_ = l8;
            }
        }
        return l10;
    }

    protected static void processReloadDataProperties(CentralStoreKey centralStoreKey) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, centralStoreKey, "processReloadDataProperties", "");
        }
        Properties properties = new Properties();
        try {
            try {
                CentralStore.fetchFromCentralStore(CentralStore.CentralStoreFlags.FETCH_PROPERTIES, centralStoreKey, properties);
            }
            finally {
                try {
                    centralStoreKey.closeCon();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sQLException) {
            ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CS_LOAD_PROPS", new Object[0]), sQLException, 10897);
        }
        long l8 = Long.parseLong(DataProperties.getProperty("pdq.propertiesRefreshInterval"));
        DataProperties.resetPropertiesBeforeMergingWithCentralStoreProperties();
        DataProperties.mergeProperties(properties);
        long l9 = Long.parseLong(DataProperties.getProperty("pdq.propertiesRefreshInterval"));
        if (l9 == 0L) {
            DataProperties.setProperty("pdq.propertiesRefreshInterval", String.valueOf(l8));
            l9 = l8;
        }
        PdqTimerServices.addToModificationDetectionQueue(centralStoreKey, l9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processReloadOfPropertiesXml(CentralStoreKey centralStoreKey, CentralStoreKey centralStoreKey2) {
        CentralStoreKey centralStoreKey3 = centralStoreKey.cloneKey();
        centralStoreKey3.setXmlKey(null);
        Object var3_3 = null;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, centralStoreKey, "processReloadOfPropertiesXml", "new redirectKey: " + DataLogger.getShortName(centralStoreKey3));
        }
        ClassLoader classLoader = XmlFileHelper.getContextClassloader();
        try {
            Object object;
            CentralStoreKey.CachedConnectionInfo cachedConnectionInfo = centralStoreKey.getCachedConnectionInfo();
            String string = cachedConnectionInfo.dsName_;
            ClassLoader classLoader2 = centralStoreKey.getAppClassLoader();
            XmlFileHelper.setContextClassloader(classLoader2);
            ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates = ConnectionExecutionHandler.appClsLoaderToResolvedStatesMap_.getValueForClsLoaderAndDS(classLoader2, string);
            CentralStoreKey centralStoreKey4 = cachedResolvedStates.getInputCaptureKey();
            HashMap hashMap = null;
            if (centralStoreKey4 != null) {
                hashMap = StaticProfileCaptureHelper.getRuntimeStmtDescMap_().get(centralStoreKey4);
            }
            String string2 = cachedConnectionInfo.connExecHandlerClassStr_;
            Class clazz = null;
            clazz = string2.equals("com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler") ? DB2ConnectionExecutionHandler.class : GenericConnectionExecutionHandler.class;
            ConnectionExecutionHandler connectionExecutionHandler = null;
            try {
                connectionExecutionHandler = AccessController.doPrivileged(PdqTimerServices.newConnectionExecutionHandler(clazz));
            }
            catch (PrivilegedActionException privilegedActionException) {
                SQLException sQLException = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_RELOAD_ERR", new Object[0]), null, privilegedActionException, 10950);
                XmlFileHelper.setContextClassloader(classLoader);
                centralStoreKey3.closeCon();
                return;
            }
            boolean bl2 = false;
            connectionExecutionHandler.setAllowUpdateofPropertiesAndResolvedStatesMaps(bl2);
            try {
                connectionExecutionHandler.initializeDefaultConstructor(cachedConnectionInfo);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_RELOAD_ERR", new Object[0]), null, sQLException, 10951);
                XmlFileHelper.setContextClassloader(classLoader);
                centralStoreKey3.closeCon();
                return;
            }
            ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates2 = centralStoreKey.getResovedStatesBeforeRedirect();
            if (cachedResolvedStates2 != null) {
                connectionExecutionHandler.applyResolvedStates(cachedResolvedStates2, classLoader2);
            }
            Properties properties = new Properties();
            try {
                connectionExecutionHandler.processRedirectedPropertiesX(classLoader2, properties, string, centralStoreKey3);
            }
            catch (SQLException sQLException) {
                SQLException sQLException3 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_RELOAD_ERR", new Object[0]), null, sQLException, 10952);
                XmlFileHelper.setContextClassloader(classLoader);
                centralStoreKey3.closeCon();
                return;
            }
            try {
                connectionExecutionHandler.validatePropertyValueCombinations(centralStoreKey3);
            }
            catch (SQLException sQLException) {
                SQLException sQLException4 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_RELOAD_ERR", new Object[0]), null, sQLException, 10953);
                XmlFileHelper.setContextClassloader(classLoader);
                centralStoreKey3.closeCon();
                return;
            }
            ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates3 = connectionExecutionHandler.postProcessingNewAppSpecificProperties(classLoader2, string);
            StaticProfileCaptureHelper staticProfileCaptureHelper = null;
            try {
                if (logger__.isLoggable(Level.FINER)) {
                    DataLogger.logAtLevelFiner(logger__, centralStoreKey3, "processReloadOfPropertiesXml", "Processed newRedirectKey, propertiesLastModTome: " + centralStoreKey3.getPropertiesLastModifiedTime() + ", XML Stream: " + DataLogger.getShortName(centralStoreKey3.getTempInputStreamHold()) + ", newCurrentStates: " + cachedResolvedStates3.toString());
                }
                staticProfileCaptureHelper = connectionExecutionHandler.createCaptureHelper();
            }
            catch (SQLException sQLException) {
                SQLException sQLException5 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_RELOAD_ERR", new Object[0]), null, sQLException, 10954);
                XmlFileHelper.setContextClassloader(classLoader);
                centralStoreKey3.closeCon();
                return;
            }
            try {
                staticProfileCaptureHelper.resetCaptureHelperStates(connectionExecutionHandler);
            }
            catch (SQLException sQLException) {
                SQLException sQLException6 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_RELOAD_ERR", new Object[0]), null, sQLException, 10955);
                XmlFileHelper.setContextClassloader(classLoader);
                centralStoreKey3.closeCon();
                return;
            }
            if (staticProfileCaptureHelper != null && (connectionExecutionHandler.getCurrentStates().getExecutionMode() == 7 || connectionExecutionHandler.getCurrentStates().getExecutionMode() == 20)) {
                try {
                    if (connectionExecutionHandler.isOkToInitRuntimeMap()) {
                        if (logger__.isLoggable(Level.FINER)) {
                            DataLogger.logAtLevelFiner(logger__, centralStoreKey3, "processReloadOfPropertiesXml", "calling captureHelperInstance.initRuntimeMapForStaticExecution (tempConnExecutionHandler)");
                        }
                        staticProfileCaptureHelper.initRuntimeMapForStaticExecution(connectionExecutionHandler);
                    }
                }
                catch (SQLException sQLException) {
                    SQLException sQLException7 = ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_CS_RELOAD_ERR", new Object[0]), null, sQLException, 10956);
                    XmlFileHelper.setContextClassloader(classLoader);
                    centralStoreKey3.closeCon();
                    return;
                }
            }
            connectionExecutionHandler.logAccessResolution(classLoader2, string);
            centralStoreKey3.setResovedStatesBeforeRedirect(cachedResolvedStates2);
            bl2 = true;
            connectionExecutionHandler.setAllowUpdateofPropertiesAndResolvedStatesMaps(bl2);
            if (logger__.isLoggable(Level.CONFIG)) {
                object = "[Thread:" + Thread.currentThread().getName() + "][PdqTimerServices][applyApplicationSpecificProperties->replaceAppSpecificProperties] ";
                logger__.logp(Level.CONFIG, null, null, (String)object + (bl2 ? "" : "NOT ") + "allowed to update Properties and ResolvedStates Maps.");
            }
            DataProperties.replaceAppSpecificProperties(bl2, classLoader2, properties, string);
            object = connectionExecutionHandler.createResolvedStates(string);
            CentralStoreKey centralStoreKey5 = ((ConnectionExecutionHandler.CachedResolvedStates)object).getOutputCaptureKey();
            CentralStoreKey centralStoreKey6 = ((ConnectionExecutionHandler.CachedResolvedStates)object).getInputCaptureKey();
            Map<CentralStoreKey, WeakReference<StaticProfileCaptureHelper>> map = connectionExecutionHandler.getStaticProfileStmtCaptureMap();
            Map<CentralStoreKey, Object> map2 = map;
            synchronized (map2) {
                connectionExecutionHandler.updateCaptureHelperInstanceMap(staticProfileCaptureHelper, centralStoreKey5);
            }
            ((ConnectionExecutionHandler.CachedResolvedStates)object).setProfilerHelperInstance(staticProfileCaptureHelper);
            connectionExecutionHandler.applyResolvedStates((ConnectionExecutionHandler.CachedResolvedStates)object, classLoader2);
            connectionExecutionHandler.postProcessingNewAppSpecificProperties(classLoader2, string);
            if (centralStoreKey6 != null && centralStoreKey4 != null && centralStoreKey6.equals(centralStoreKey4) && centralStoreKey6.hashCode() == centralStoreKey4.hashCode() && hashMap != null) {
                Map<CentralStoreKey, Object> map3 = map2 = StaticProfileCaptureHelper.getRuntimeStmtDescMap_();
                synchronized (map3) {
                    map2.remove(centralStoreKey4);
                    map2.put(centralStoreKey6, hashMap);
                }
            }
            centralStoreKey.setModified(true);
        }
        finally {
            XmlFileHelper.setContextClassloader(classLoader);
            centralStoreKey3.closeCon();
        }
    }

    public static final PrivilegedExceptionAction<ConnectionExecutionHandler> newConnectionExecutionHandler(final Class<? extends ConnectionExecutionHandler> clazz) {
        return new PrivilegedExceptionAction<ConnectionExecutionHandler>(){

            @Override
            public ConnectionExecutionHandler run() throws IllegalAccessException, InstantiationException {
                return (ConnectionExecutionHandler)clazz.newInstance();
            }
        };
    }

    static {
        if (PdqServiceThreadProvider.isThreadingEnabled()) {
            PdqTimerServices.initTimerServices();
            PdqTimerServices.initShutdownServices();
        }
    }
}

